/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp.views;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.View;

public class SimpleResponseView
implements View {
    public static final String SC_KEY = "sc";
    public static final String CONTENT_KEY = "content";
    private static final int DEFAULT_SC = 200;
    private static final String CONTENT_TYPE = "text/plain; charset=UTF-8";
    public static final String CUSTOM_HEADERS_KEY = "headers";
    private static final SimpleResponseView INSTANCE = new SimpleResponseView();

    public static SimpleResponseView getInstance() {
        return INSTANCE;
    }

    private SimpleResponseView() {
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map customHeaders;
        Integer sc = (Integer)model.get(SC_KEY);
        if (sc == null) {
            sc = 200;
        }
        response.setStatus(sc.intValue());
        response.setContentType(this.getContentType());
        if (model.containsKey(CUSTOM_HEADERS_KEY) && (customHeaders = (Map)model.get(CUSTOM_HEADERS_KEY)) != null) {
            for (String headerName : customHeaders.keySet()) {
                response.setHeader(headerName, (String)customHeaders.get(headerName));
            }
        }
        try (ServletOutputStream out = response.getOutputStream();){
            String content = (String)model.get(CONTENT_KEY);
            if (content != null) {
                byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
                response.setContentLength(contentBytes.length);
                out.write(contentBytes);
            } else {
                response.setContentLength(0);
            }
        }
    }
}

