/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderActionType;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderOperationPanel;
import org.eclipse.jst.common.project.facet.ui.libprov.internal.LibraryProviderFrameworkUiImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public final class LibraryInstallPanel
extends Composite {
    private final LibraryInstallDelegate delegate;
    private final Group providersGroup;
    private final Combo providersCombo;
    private final PageBook providersPageBook;
    private final Map<ILibraryProvider, Control> providerPages;
    private final Composite noProviderComposite;

    public LibraryInstallPanel(Composite parent, LibraryInstallDelegate delegate, String label) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutUtil.gl((int)1, (int)0, (int)0));
        this.delegate = delegate;
        this.providerPages = new HashMap<ILibraryProvider, Control>();
        this.providersGroup = new Group((Composite)this, 0);
        this.providersGroup.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.providersGroup.setLayout((Layout)GridLayoutUtil.gl((int)1));
        this.providersGroup.setText(label != null ? label : Resources.providersGroupLabel);
        Composite providersComboComposite = new Composite((Composite)this.providersGroup, 0);
        providersComboComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
        providersComboComposite.setLayout((Layout)GridLayoutUtil.gl((int)2, (int)0, (int)0));
        Label providersComboLabel = new Label(providersComboComposite, 0);
        providersComboLabel.setLayoutData((Object)GridLayoutUtil.gd());
        providersComboLabel.setText(Resources.providersComboLabel);
        this.providersCombo = new Combo(providersComboComposite, 2056);
        this.providersCombo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.providersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LibraryInstallPanel.this.handleProviderSelected();
            }
        });
        Label separator = new Label((Composite)this.providersGroup, 258);
        separator.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.providersPageBook = new PageBook((Composite)this.providersGroup, 0);
        this.providersPageBook.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.noProviderComposite = new Composite((Composite)this.providersPageBook, 0);
        this.noProviderComposite.setLayout((Layout)GridLayoutUtil.gl((int)1));
        this.noProviderComposite.setVisible(false);
        Label noProviderLabel = new Label(this.noProviderComposite, 0);
        noProviderLabel.setText(Resources.noProvidersAvailable);
        noProviderLabel.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.handleProvidersSetChanged();
        final IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChanged(String property, Object oldValue, Object newValue) {
                LibraryInstallPanel.this.handleOperationConfigChanged(property, oldValue, newValue);
            }
        };
        this.delegate.addListener(listener, new String[0]);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                LibraryInstallPanel.this.delegate.removeListener(listener);
            }
        });
    }

    private void handleProvidersSetChanged() {
        this.providerPages.clear();
        this.providersCombo.setItems(new String[0]);
        List providers = this.delegate.getLibraryProviders();
        ILibraryProvider selectedProvider = this.delegate.getLibraryProvider();
        for (ILibraryProvider provider : providers) {
            this.providersCombo.add(provider.getLabel());
            int index = this.providersCombo.getItemCount() - 1;
            this.providersCombo.setData(String.valueOf(index), (Object)provider);
            LibraryProviderOperationConfig cfg = this.delegate.getLibraryProviderOperationConfig(provider);
            LibraryProviderOperationPanel panel = LibraryProviderFrameworkUiImpl.get().getOperationPanel(provider, LibraryProviderActionType.INSTALL);
            if (panel != null) {
                panel.setOperationConfig(cfg);
                Control panelControl = panel.createControl((Composite)this.providersPageBook);
                panelControl.setLayoutData((Object)GridLayoutUtil.gdfill());
                panelControl.setVisible(false);
                this.providerPages.put(provider, panelControl);
            }
            if (!provider.equals(selectedProvider)) continue;
            this.providersCombo.select(index);
        }
        this.handleProviderSelected();
    }

    private void handleProviderSelected() {
        int selection = this.providersCombo.getSelectionIndex();
        if (selection == -1) {
            this.delegate.setLibraryProvider(null);
            this.providersPageBook.showPage((Control)this.noProviderComposite);
        } else {
            ILibraryProvider provider = (ILibraryProvider)this.providersCombo.getData(String.valueOf(selection));
            this.delegate.setLibraryProvider(provider);
            Control providerPanelControl = this.providerPages.get(provider);
            this.providersPageBook.showPage(providerPanelControl);
        }
        this.getShell().layout(true, true);
    }

    private void handleOperationConfigChanged(final String property, final Object oldValue, final Object newValue) {
        if (this.isDisposed()) {
            return;
        }
        if (this.getDisplay().getThread() != Thread.currentThread()) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    LibraryInstallPanel.this.handleOperationConfigChanged(property, oldValue, newValue);
                }
            });
            return;
        }
        if (property.equals(LibraryInstallDelegate.PROP_AVAILABLE_PROVIDERS)) {
            this.handleProvidersSetChanged();
        } else if (property.equals(LibraryInstallDelegate.PROP_SELECTED_PROVIDER)) {
            ILibraryProvider selectedProvider = this.delegate.getLibraryProvider();
            int i = 0;
            int n = this.providersCombo.getItemCount();
            while (i < n) {
                if (this.providersCombo.getData(String.valueOf(i)).equals(selectedProvider)) {
                    this.providersCombo.select(i);
                    break;
                }
                ++i;
            }
            this.handleProviderSelected();
        }
    }

    private static final class Resources
    extends NLS {
        public static String providersGroupLabel;
        public static String providersComboLabel;
        public static String noProvidersAvailable;

        static {
            Resources.initializeMessages((String)LibraryInstallPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

