/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.datamodel.properties.IServerContextRootDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentOperation;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.resources.ResourceTimestampMappings;
import org.eclipse.wst.common.componentcore.internal.util.ArtifactEditRegistryReader;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ComponentUtilities {
    private static final ResourceTimestampMappings ContextRootMapping = new ResourceTimestampMappings();

    public static void ensureContainerNotReadOnly(IResource resource) {
        IContainer container;
        if (resource != null && !resource.exists() && (container = resource.getParent()) != null) {
            ResourceAttributes attr = container.getResourceAttributes();
            if (!attr.isReadOnly()) {
                container = container.getParent();
            }
            attr.setReadOnly(false);
        }
    }

    public static IFolder createFolderInComponent(IVirtualComponent component, String folderName) throws CoreException {
        if (folderName != null) {
            IVirtualFolder rootfolder = component.getRootFolder();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(new Path(rootfolder.getProject().getName()).append(folderName));
            if (!folder.exists()) {
                ProjectUtilities.ensureContainerNotReadOnly((IResource)folder);
                folder.create(true, true, null);
            }
            return folder;
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForRead(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader;
        IArtifactEditFactory factory;
        if (comp != null && (factory = (reader = ArtifactEditRegistryReader.instance()).getArtifactEdit(comp.getProject())) != null) {
            return factory.createArtifactEditForRead(comp);
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForRead(IVirtualComponent comp, String type) {
        ArtifactEditRegistryReader reader;
        IArtifactEditFactory factory;
        if (comp != null && (factory = (reader = ArtifactEditRegistryReader.instance()).getArtifactEdit(type)) != null) {
            return factory.createArtifactEditForRead(comp);
        }
        return null;
    }

    public static IFile findFile(IVirtualComponent comp, IPath aPath) throws CoreException {
        IResource resource;
        if (comp == null || aPath == null || comp.isBinary()) {
            return null;
        }
        IVirtualFolder root = comp.getRootFolder();
        IVirtualResource file = root.findMember(aPath);
        if (file != null && file.getType() == 16 && (resource = file.getUnderlyingResource()).getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    public static IVirtualComponent findComponent(IResource res) {
        return (IVirtualComponent)res.getAdapter(IVirtualComponent.class);
    }

    public static IVirtualComponent[] getAllWorkbenchComponents() {
        ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        int i = 0;
        while (i < projects.size()) {
            if (ModuleCoreNature.isFlexibleProject(projects.get(i))) {
                IVirtualComponent wbComp = ComponentCore.createComponent(projects.get(i));
                components.add(wbComp);
            }
            ++i;
        }
        IVirtualComponent[] temp = components.toArray(new IVirtualComponent[components.size()]);
        return temp;
    }

    public static IVirtualComponent getComponent(String componentName) {
        IVirtualComponent[] allComponents = ComponentUtilities.getAllWorkbenchComponents();
        int i = 0;
        while (i < allComponents.length) {
            if (allComponents[i].getName().equals(componentName)) {
                return allComponents[i];
            }
            ++i;
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForWrite(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader;
        IArtifactEditFactory factory;
        if (comp != null && (factory = (reader = ArtifactEditRegistryReader.instance()).getArtifactEdit(comp.getProject())) != null) {
            return factory.createArtifactEditForWrite(comp);
        }
        return null;
    }

    public static IVirtualComponent findComponent(EObject anObject) {
        Resource res = anObject.eResource();
        return ComponentUtilities.findComponent(res);
    }

    public static IVirtualComponent findComponent(Resource aResource) {
        IFile file = WorkbenchResourceHelper.getFile((Resource)aResource);
        if (file == null) {
            return null;
        }
        return (IVirtualComponent)file.getAdapter(IVirtualComponent.class);
    }

    public static CreateReferenceComponentsOp createReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        return new CreateReferenceComponentsOp(model);
    }

    public static CreateReferenceComponentsOp createWLPReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
        if (modHandlesList != null) {
            HashMap<IVirtualComponent, String> map = new HashMap<IVirtualComponent, String>();
            int i = 0;
            while (i < modHandlesList.size()) {
                IVirtualComponent comp = (IVirtualComponent)modHandlesList.get(i);
                String uri = String.valueOf(comp.getName().replace(' ', '_')) + ".jar";
                map.put(comp, uri);
                ++i;
            }
            if (map.size() > 0) {
                model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", map);
            }
        }
        return new CreateReferenceComponentsOp(model);
    }

    public static RemoveReferenceComponentOperation removeWLPReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
        return new RemoveReferenceComponentOperation(model);
    }

    public static RemoveReferenceComponentOperation removeReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        return new RemoveReferenceComponentOperation(model);
    }

    public static IVirtualComponent[] getComponents(IProject[] projects) {
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
        if (projects != null) {
            int i = 0;
            while (i < projects.length) {
                IVirtualComponent comp;
                if (projects[i] != null && (comp = ComponentCore.createComponent(projects[i])) != null && comp.exists()) {
                    result.add(comp);
                }
                ++i;
            }
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }

    public static String getServerContextRoot(IProject project) {
        if (!ContextRootMapping.hasChanged((IResource)project)) {
            String data = null;
            if (!ContextRootMapping.hasCacheError((IResource)project) && ContextRootMapping.hasCacheData((IResource)project)) {
                data = (String)ContextRootMapping.getData((IResource)project);
            }
            return data;
        }
        StructureEdit moduleCore = null;
        WorkbenchComponent wbComponent = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead(project);
            if (moduleCore == null || moduleCore.getComponent() == null) {
                ContextRootMapping.markError((IResource)project);
                return null;
            }
            wbComponent = moduleCore.getComponent();
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
        EList existingProps = wbComponent.getProperties();
        int i = 0;
        while (i < existingProps.size()) {
            Property prop = (Property)existingProps.get(i);
            if (prop.getName().equals("context-root")) {
                ContextRootMapping.mark((IResource)project, prop.getValue());
                return prop.getValue();
            }
            ++i;
        }
        ContextRootMapping.markError((IResource)project);
        return null;
    }

    public static void setServerContextRoot(IProject project, String newContextRoot) {
        IDataModel model = DataModelFactory.createDataModel(IServerContextRootDataModelProperties.class);
        model.setProperty("IServerContextRootDataModelProperties.PROJECT", (Object)project);
        model.setStringProperty("IServerContextRootDataModelProperties.CONTEXT_ROOT", newContextRoot);
        try {
            model.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ModulecorePlugin.logError(e);
        }
    }

    public static String getDeployUriOfUtilComponent(IVirtualReference reference) {
        return ComponentUtilities.getDeployUriOfComponent(reference, ".jar");
    }

    public static String getDeployUriOfComponent(IVirtualReference reference, String extension) {
        String archiveName = reference.getArchiveName();
        String uri = null;
        uri = archiveName != null && !archiveName.equals("") ? reference.getRuntimePath() + "/" + reference.getArchiveName() : reference.getRuntimePath() + "/" + reference.getReferencedComponent().getProject().getName() + extension;
        return uri;
    }
}

