/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GwtIncompatible(value="java.io")
public abstract class JsFileLineParser {
    static final DiagnosticType PARSE_WARNING = DiagnosticType.warning("DEPS_PARSE_WARNING", "{0}\n{1}");
    public static final DiagnosticType PARSE_ERROR = DiagnosticType.error("DEPS_PARSE_ERROR", "{0}\n{1}");
    boolean shortcutMode = false;
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("\\s*(?:'((?:\\\\'|[^'])*?)'|\"((?:\\\\\"|[^\"])*?)\")\\s*");
    private Matcher valueMatcher = STRING_LITERAL_PATTERN.matcher("");
    String filePath;
    int lineNum;
    ErrorManager errorManager;
    boolean parseSucceeded;

    public JsFileLineParser(ErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public void setShortcutMode(boolean mode) {
        this.shortcutMode = mode;
    }

    public boolean didParseSucceed() {
        return this.parseSucceeded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doParse(String filePath, Reader fileContents) {
        this.filePath = filePath;
        this.parseSucceeded = true;
        BufferedReader lineBuffer = new BufferedReader(fileContents);
        String line = null;
        this.lineNum = 0;
        boolean inMultilineComment = false;
        try {
            while (null != (line = lineBuffer.readLine())) {
                ++this.lineNum;
                try {
                    String revisedLine = line;
                    if (inMultilineComment) {
                        int endOfComment = revisedLine.indexOf("*/");
                        if (endOfComment != -1) {
                            revisedLine = revisedLine.substring(endOfComment + 2);
                            inMultilineComment = false;
                        } else {
                            revisedLine = "";
                        }
                    }
                    if (!inMultilineComment) {
                        while (true) {
                            int startOfLineComment = revisedLine.indexOf("//");
                            int startOfMultilineComment = revisedLine.indexOf("/*");
                            if (startOfLineComment != -1 && (startOfMultilineComment == -1 || startOfLineComment < startOfMultilineComment)) {
                                revisedLine = revisedLine.substring(0, startOfLineComment);
                                break;
                            }
                            if (startOfMultilineComment == -1) break;
                            int endOfMultilineComment = revisedLine.indexOf("*/", startOfMultilineComment + 2);
                            if (endOfMultilineComment == -1) {
                                revisedLine = revisedLine.substring(0, startOfMultilineComment);
                                inMultilineComment = true;
                                break;
                            }
                            revisedLine = revisedLine.substring(0, startOfMultilineComment) + revisedLine.substring(endOfMultilineComment + 2);
                        }
                    }
                    if (revisedLine.isEmpty() || this.parseLine(revisedLine) || !this.shortcutMode) continue;
                    return;
                }
                catch (ParseException e) {
                    this.errorManager.report(e.isFatal() ? CheckLevel.ERROR : CheckLevel.WARNING, JSError.make(filePath, this.lineNum, 0, e.isFatal() ? PARSE_ERROR : PARSE_WARNING, e.getMessage(), line));
                    this.parseSucceeded = this.parseSucceeded && !e.isFatal();
                }
            }
            return;
        }
        catch (IOException e) {
            this.errorManager.report(CheckLevel.ERROR, JSError.make(filePath, 0, 0, PARSE_ERROR, "Error reading file: " + filePath));
            this.parseSucceeded = false;
        }
    }

    abstract boolean parseLine(String var1) throws ParseException;

    String parseJsString(String jsStringLiteral) throws ParseException {
        this.valueMatcher.reset(jsStringLiteral);
        if (!this.valueMatcher.matches()) {
            throw new ParseException("Syntax error in JS String literal", true);
        }
        return this.valueMatcher.group(1) != null ? this.valueMatcher.group(1) : this.valueMatcher.group(2);
    }

    List<String> parseJsStringArray(String input) throws ParseException {
        ArrayList<String> results = new ArrayList<String>();
        int indexStart = input.indexOf(91);
        int indexEnd = input.lastIndexOf(93);
        if (indexStart == -1 || indexEnd == -1) {
            throw new ParseException("Syntax error when parsing JS array", true);
        }
        String innerValues = input.substring(indexStart + 1, indexEnd);
        if (!innerValues.trim().isEmpty()) {
            this.valueMatcher.reset(innerValues);
            while (true) {
                if (!this.valueMatcher.lookingAt()) {
                    throw new ParseException("Syntax error in JS String literal", true);
                }
                results.add(this.valueMatcher.group(1) != null ? this.valueMatcher.group(1) : this.valueMatcher.group(2));
                if (this.valueMatcher.hitEnd()) break;
                if (innerValues.charAt(this.valueMatcher.end()) != ',') {
                    throw new ParseException("Missing comma in string array", true);
                }
                this.valueMatcher.region(this.valueMatcher.end() + 1, this.valueMatcher.regionEnd());
            }
        }
        return results;
    }

    Map<String, String> parseJsStringMap(String input) throws ParseException {
        input = CharMatcher.whitespace().trimFrom((CharSequence)input);
        JsFileLineParser.check(!input.isEmpty() && input.charAt(0) == '{' && input.charAt(input.length() - 1) == '}', "Syntax error when parsing JS object");
        input = input.substring(1, input.length() - 1).trim();
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        boolean done = input.isEmpty();
        this.valueMatcher.reset(input);
        while (!done) {
            JsFileLineParser.check(this.valueMatcher.lookingAt(), "Bad key in JS object literal");
            String key = this.valueMatcher.group(1) != null ? this.valueMatcher.group(1) : this.valueMatcher.group(2);
            JsFileLineParser.check(!this.valueMatcher.hitEnd(), "Missing value in JS object literal");
            JsFileLineParser.check(input.charAt(this.valueMatcher.end()) == ':', "Missing colon in JS object literal");
            this.valueMatcher.region(this.valueMatcher.end() + 1, this.valueMatcher.regionEnd());
            JsFileLineParser.check(this.valueMatcher.lookingAt(), "Bad value in JS object literal");
            String val = this.valueMatcher.group(1) != null ? this.valueMatcher.group(1) : this.valueMatcher.group(2);
            results.put(key, val);
            if (!this.valueMatcher.hitEnd()) {
                JsFileLineParser.check(input.charAt(this.valueMatcher.end()) == ',', "Missing comma in JS object literal");
                this.valueMatcher.region(this.valueMatcher.end() + 1, this.valueMatcher.regionEnd());
                continue;
            }
            done = true;
        }
        return results;
    }

    private static void check(boolean condition, String message) throws ParseException {
        if (!condition) {
            throw new ParseException(message, true);
        }
    }

    static class ParseException
    extends Exception {
        public static final long serialVersionUID = 1L;
        private boolean fatal;

        public ParseException(String message, boolean fatal) {
            super(message);
            this.fatal = fatal;
        }

        public boolean isFatal() {
            return this.fatal;
        }
    }
}

