/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BytesRef;

public class KnnVectorField
extends Field {
    private static FieldType createType(float[] v, VectorSimilarityFunction similarityFunction) {
        if (v == null) {
            throw new IllegalArgumentException("vector value must not be null");
        }
        return KnnVectorField.createType(v.length, VectorEncoding.FLOAT32, similarityFunction);
    }

    private static FieldType createType(BytesRef v, VectorSimilarityFunction similarityFunction) {
        if (v == null) {
            throw new IllegalArgumentException("vector value must not be null");
        }
        return KnnVectorField.createType(v.length, VectorEncoding.BYTE, similarityFunction);
    }

    private static FieldType createType(int dimension, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) {
        if (dimension == 0) {
            throw new IllegalArgumentException("cannot index an empty vector");
        }
        if (dimension > 1024) {
            throw new IllegalArgumentException("cannot index vectors with dimension greater than 1024");
        }
        if (similarityFunction == null) {
            throw new IllegalArgumentException("similarity function must not be null");
        }
        FieldType type = new FieldType();
        type.setVectorAttributes(dimension, vectorEncoding, similarityFunction);
        type.freeze();
        return type;
    }

    public static FieldType createFieldType(int dimension, VectorSimilarityFunction similarityFunction) {
        return KnnVectorField.createFieldType(dimension, VectorEncoding.FLOAT32, similarityFunction);
    }

    public static FieldType createFieldType(int dimension, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) {
        FieldType type = new FieldType();
        type.setVectorAttributes(dimension, vectorEncoding, similarityFunction);
        type.freeze();
        return type;
    }

    public KnnVectorField(String name, float[] vector, VectorSimilarityFunction similarityFunction) {
        super(name, KnnVectorField.createType(vector, similarityFunction));
        this.fieldsData = vector;
    }

    public KnnVectorField(String name, BytesRef vector, VectorSimilarityFunction similarityFunction) {
        super(name, KnnVectorField.createType(vector, similarityFunction));
        this.fieldsData = vector;
    }

    public KnnVectorField(String name, float[] vector) {
        this(name, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    public KnnVectorField(String name, float[] vector, FieldType fieldType) {
        super(name, fieldType);
        if (fieldType.vectorEncoding() != VectorEncoding.FLOAT32) {
            throw new IllegalArgumentException("Attempt to create a vector for field " + name + " using float[] but the field encoding is " + fieldType.vectorEncoding());
        }
        this.fieldsData = vector;
    }

    public KnnVectorField(String name, BytesRef vector, FieldType fieldType) {
        super(name, fieldType);
        if (fieldType.vectorEncoding() != VectorEncoding.BYTE) {
            throw new IllegalArgumentException("Attempt to create a vector for field " + name + " using BytesRef but the field encoding is " + fieldType.vectorEncoding());
        }
        this.fieldsData = vector;
    }

    public float[] vectorValue() {
        return (float[])this.fieldsData;
    }

    public void setVectorValue(float[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (value.length != this.type.vectorDimension()) {
            throw new IllegalArgumentException("value length " + value.length + " must match field dimension " + this.type.vectorDimension());
        }
        this.fieldsData = value;
    }
}

