/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.Transaction;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractCreateExpandableFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractUpdateMarkerFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractUpdateEventFeature;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.AbstractUpdateEventDefinitionFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractExpandableActivityFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AddExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.bpmn2.modeler.ui.features.event.definitions.CompensateEventDefinitionContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.definitions.ConditionalEventDefinitionContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.definitions.ErrorEventDefinitionContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.definitions.EscalationEventDefinitionContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.definitions.MessageEventDefinitionContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.definitions.SignalEventDefinitionContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.definitions.TimerEventDefinitionContainer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class SubProcessFeatureContainer
extends AbstractExpandableActivityFeatureContainer {
    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof SubProcess && !(o instanceof AdHocSubProcess) && !(o instanceof Transaction);
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateSubProcessFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddSubProcessFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = (MultiUpdateFeature)super.getUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateSubProcessDecoratorFeature(fp));
        return multiUpdate;
    }

    public static class AddSubProcessFeature
    extends AddExpandableActivityFeature<SubProcess> {
        public AddSubProcessFeature(IFeatureProvider fp) {
            super(fp);
        }

        public Class getBusinessObjectType() {
            return SubProcess.class;
        }
    }

    public static class CreateSubProcessFeature
    extends AbstractCreateExpandableFlowNodeFeature<SubProcess> {
        public CreateSubProcessFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_SUB_PROCESS;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getSubProcess();
        }
    }

    public static class UpdateSubProcessDecoratorFeature
    extends AbstractUpdateMarkerFeature<SubProcess> {
        public UpdateSubProcessDecoratorFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            PictogramElement pe = context.getPictogramElement();
            if (pe instanceof ContainerShape) {
                Object o = this.getBusinessObjectForPictogramElement(pe);
                return o instanceof SubProcess;
            }
            return false;
        }

        public IReason updateNeeded(IUpdateContext context) {
            PictogramElement pe = context.getPictogramElement();
            if (pe instanceof ContainerShape) {
                boolean isVisible = false;
                ContainerShape subProcessShape = (ContainerShape)pe;
                SubProcess subProcess = (SubProcess)this.getBusinessObjectForPictogramElement(pe);
                for (Shape s : subProcessShape.getChildren()) {
                    if (!ShapeDecoratorUtil.isEventSubProcessDecorator((PictogramElement)s)) continue;
                    isVisible = pe.isVisible();
                }
                EventDefinition eventDefinition = null;
                for (FlowElement fe : subProcess.getFlowElements()) {
                    if (!(fe instanceof StartEvent)) continue;
                    StartEvent startEvent = (StartEvent)fe;
                    if (startEvent.getEventDefinitions().size() <= 0) break;
                    eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                    break;
                }
                if (subProcess.isTriggeredByEvent()) {
                    if (!FeatureSupport.isElementExpanded((BaseElement)subProcess)) {
                        if (super.updateNeeded(context).toBoolean()) {
                            return Reason.createTrueReason((String)Messages.SubProcessFeatureContainer_Decorator_Changed);
                        }
                        if (!isVisible && eventDefinition != null) {
                            return Reason.createTrueReason((String)Messages.SubProcessFeatureContainer_Show_Decorator);
                        }
                    }
                } else if (isVisible) {
                    return Reason.createTrueReason((String)Messages.SubProcessFeatureContainer_Hide_Decorator);
                }
            }
            return Reason.createFalseReason();
        }

        public boolean update(IUpdateContext context) {
            return super.update(context);
        }

        protected String getPropertyKey() {
            return "event.subprocess.decorator";
        }

        protected boolean isPropertyChanged(SubProcess element, String propertyValue) {
            return !this.convertPropertyToString(element).equals(propertyValue);
        }

        protected void doUpdate(SubProcess subProcess, ContainerShape subProcessShape) {
            EventDefinition eventDefinition = null;
            boolean isMultiple = false;
            boolean isParallel = false;
            StartEvent startEvent = null;
            for (FlowElement fe : subProcess.getFlowElements()) {
                if (!(fe instanceof StartEvent)) continue;
                startEvent = (StartEvent)fe;
                if (startEvent.getEventDefinitions().size() > 0) {
                    eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                }
                if (startEvent.getEventDefinitions().size() <= 1) break;
                isMultiple = true;
                isParallel = startEvent.isParallelMultiple();
                break;
            }
            for (Shape s : subProcessShape.getChildren()) {
                if (!ShapeDecoratorUtil.isEventSubProcessDecorator((PictogramElement)s)) continue;
                Graphiti.getPeService().deletePictogramElement((PictogramElement)s);
                break;
            }
            if (subProcess.isTriggeredByEvent() && !FeatureSupport.isElementExpanded((PictogramElement)subProcessShape)) {
                ContainerShape decoratorShape = null;
                if (eventDefinition != null) {
                    decoratorShape = ShapeDecoratorUtil.createEventSubProcessDecorator((ContainerShape)subProcessShape, (boolean)startEvent.isIsInterrupting());
                }
                if (isMultiple) {
                    ContainerShape s = Graphiti.getPeCreateService().createContainerShape(decoratorShape, false);
                    Rectangle r = Graphiti.getGaCreateService().createInvisibleRectangle((PictogramElement)decoratorShape);
                    Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)r, 1, 1, 20, 20);
                    if (isParallel) {
                        AbstractUpdateEventDefinitionFeature.drawParallelMultiple((Event)startEvent, (Shape)s);
                    } else {
                        AbstractUpdateEventDefinitionFeature.drawMultiple((Event)startEvent, (Shape)s);
                    }
                } else if (eventDefinition instanceof MessageEventDefinition) {
                    MessageEventDefinitionContainer.draw(decoratorShape);
                } else if (eventDefinition instanceof TimerEventDefinition) {
                    TimerEventDefinitionContainer.draw(decoratorShape);
                } else if (eventDefinition instanceof CompensateEventDefinition) {
                    CompensateEventDefinitionContainer.draw(decoratorShape);
                } else if (eventDefinition instanceof ConditionalEventDefinition) {
                    ConditionalEventDefinitionContainer.draw(decoratorShape);
                } else if (eventDefinition instanceof ErrorEventDefinition) {
                    ErrorEventDefinitionContainer.draw(decoratorShape);
                } else if (eventDefinition instanceof EscalationEventDefinition) {
                    EscalationEventDefinitionContainer.draw(decoratorShape);
                } else if (eventDefinition instanceof SignalEventDefinition) {
                    SignalEventDefinitionContainer.draw(decoratorShape);
                }
            }
        }

        protected String convertPropertyToString(SubProcess element) {
            for (FlowElement fe : element.getFlowElements()) {
                if (!(fe instanceof StartEvent)) continue;
                return AbstractUpdateEventFeature.getEventDefinitionsValue((Event)((StartEvent)fe));
            }
            return "";
        }
    }
}

