/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecoretools.design.service.EcoreToolsDesignPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PropertiesServices {
    protected static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";

    public List<EStructuralFeature> removeFeaturesToHide(EObject ctx, Collection<EStructuralFeature> unfiltered) {
        ArrayList toBeFilterd = Lists.newArrayList(unfiltered);
        toBeFilterd.remove(GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS);
        toBeFilterd.remove(GenModelPackage.Literals.GEN_PACKAGE__ECORE_PACKAGE);
        toBeFilterd.remove(GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS);
        toBeFilterd.remove(GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE);
        if (ctx instanceof EReference) {
            toBeFilterd.remove(EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL);
        }
        toBeFilterd.remove(GenModelPackage.Literals.GEN_ENUM__ECORE_ENUM);
        toBeFilterd.remove(GenModelPackage.Literals.GEN_TYPE_PARAMETER__ECORE_TYPE_PARAMETER);
        PriorityComparator comparator = new PriorityComparator(ImmutableList.of((Object)EcorePackage.Literals.ENAMED_ELEMENT__NAME, (Object)EcorePackage.Literals.ETYPED_ELEMENT__ETYPE, (Object)EcorePackage.Literals.ETYPED_ELEMENT__LOWER_BOUND, (Object)EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND, (Object)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME, (Object)EcorePackage.Literals.ECLASSIFIER__INSTANCE_TYPE_NAME, (Object)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL, (Object)EcorePackage.Literals.EREFERENCE__EOPPOSITE, (Object)EcorePackage.Literals.EREFERENCE__CONTAINMENT, (Object)EcorePackage.Literals.ESTRUCTURAL_FEATURE__TRANSIENT, (Object)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DERIVED));
        return Ordering.from(comparator).sortedCopy((Iterable)toBeFilterd);
    }

    public List<EObject> removeSemanticElementsToHide(EObject ctx, Collection<EObject> unfiltered, DSemanticDecorator selection) {
        ArrayList filtered = Lists.newArrayList();
        for (EObject eObject : unfiltered) {
            if (eObject instanceof EParameter) continue;
            filtered.add(eObject);
        }
        if (selection instanceof DEdge && ctx instanceof EClass && ((DEdge)selection).getActualMapping() instanceof EdgeMapping && "EC ESupertypes".equals(((EdgeMapping)((DEdge)selection).getActualMapping()).getName())) {
            filtered.addAll(((EClass)ctx).getEGenericSuperTypes());
            for (EGenericType genType : ((EClass)ctx).getEGenericSuperTypes()) {
                filtered.addAll(genType.getETypeArguments());
            }
        }
        return filtered;
    }

    public EStringToStringMapEntryImpl getVisibleDocAnnotations(EObject self) {
        if (self instanceof EModelElement) {
            EAnnotation eAnnot = ((EModelElement)self).getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
            if (eAnnot != null) {
                for (EStringToStringMapEntryImpl mapEntry : Iterables.filter((Iterable)eAnnot.getDetails(), EStringToStringMapEntryImpl.class)) {
                    if (!"documentation".equals(mapEntry.getKey())) continue;
                    return mapEntry;
                }
            }
        } else if (self instanceof EAnnotation) {
            for (EStringToStringMapEntryImpl mapEntry : Iterables.filter((Iterable)((EAnnotation)self).getDetails(), EStringToStringMapEntryImpl.class)) {
                if (!"documentation".equals(mapEntry.getKey())) continue;
                return mapEntry;
            }
        } else if (self instanceof EStringToStringMapEntryImpl && "documentation".equals(((EStringToStringMapEntryImpl)self).getKey())) {
            return (EStringToStringMapEntryImpl)self;
        }
        return null;
    }

    public EObject setDocAnnotation(EObject self, String value) {
        if (self instanceof EModelElement) {
            EAnnotation eAnnot = ((EModelElement)self).getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
            if (eAnnot != null) {
                for (EStringToStringMapEntryImpl mapEntry : Iterables.filter((Iterable)eAnnot.getDetails(), EStringToStringMapEntryImpl.class)) {
                    if (!"documentation".equals(mapEntry.getKey())) continue;
                    mapEntry.setValue(value);
                }
            } else {
                EAnnotation newAnnot = EcoreFactory.eINSTANCE.createEAnnotation();
                newAnnot.setSource(GEN_MODEL_PACKAGE_NS_URI);
                newAnnot.getDetails().put((Object)"documentation", (Object)value);
                ((EModelElement)self).getEAnnotations().add((Object)newAnnot);
            }
        } else if (self instanceof EAnnotation) {
            for (EStringToStringMapEntryImpl mapEntry : Iterables.filter((Iterable)((EAnnotation)self).getDetails(), EStringToStringMapEntryImpl.class)) {
                if (!"documentation".equals(mapEntry.getKey())) continue;
                mapEntry.setValue(value);
            }
        } else if (self instanceof EStringToStringMapEntryImpl && "documentation".equals(((EStringToStringMapEntryImpl)self).getKey())) {
            ((EStringToStringMapEntryImpl)self).setValue(value);
        }
        return self;
    }

    public boolean isJavaFileGenerated(EObject cur) {
        URI javaImplementationURI = this.getJavaImplementationURI(cur);
        if (javaImplementationURI != null && cur.eResource() != null && cur.eResource().getResourceSet() != null && cur.eResource().getResourceSet().getURIConverter() != null) {
            return cur.eResource().getResourceSet().getURIConverter().exists(javaImplementationURI, Collections.EMPTY_MAP);
        }
        return false;
    }

    public String getJavaImplementationPath(EObject cur) {
        URI targetFile = this.getJavaImplementationURI(cur);
        if (targetFile != null) {
            return targetFile.toString();
        }
        return null;
    }

    private URI getJavaImplementationURI(EObject cur) {
        GenClass gClass = null;
        if (cur instanceof GenFeature) {
            gClass = ((GenFeature)cur).getGenClass();
        }
        if (cur instanceof GenEnumLiteral) {
            gClass = ((GenEnumLiteral)cur).getGenEnum();
        }
        if (cur instanceof GenClassifier) {
            gClass = (GenClassifier)cur;
        }
        if (cur instanceof GenEnum) {
            gClass = (GenClassifier)cur;
        }
        String className = "";
        if (gClass instanceof GenClass) {
            className = gClass.getClassName();
        } else if (gClass instanceof GenEnum) {
            className = ((GenEnum)gClass).getClassifierInstanceName();
        }
        if (gClass != null && gClass.getGenPackage() != null) {
            String packageName = gClass.getGenPackage().getClassPackageName();
            URI targetDirectory = URI.createURI((String)gClass.getGenPackage().getGenModel().getModelDirectory()).appendSegments(packageName.split("\\."));
            URI targetFile = targetDirectory.appendSegment(String.valueOf(className) + ".java");
            return targetFile;
        }
        return null;
    }

    public String upperBoundDisplay(ETypedElement host) {
        if (host.getUpperBound() == -1) {
            return "*";
        }
        return Integer.valueOf(host.getUpperBound()).toString();
    }

    public ETypedElement setUpperBound(ETypedElement host, String newValue) {
        if ("*".equals(newValue)) {
            host.setUpperBound(-1);
        } else {
            host.setUpperBound(Integer.valueOf(newValue).intValue());
        }
        return host;
    }

    public EObject eGetMonoRef(EObject cur, EStructuralFeature ref) {
        return (EObject)cur.eGet(ref);
    }

    public EObject moveUpInContainer(EObject cur) {
        EObject container = cur.eContainer();
        if (container != null) {
            EList siblings = (EList)container.eGet(cur.eContainingFeature());
            int oldPosition = siblings.indexOf((Object)cur);
            int newPosition = oldPosition - 1;
            if (newPosition < 0) {
                newPosition = 0;
            }
            siblings.move(newPosition, (Object)cur);
        }
        return cur;
    }

    public EObject moveDownInContainer(EObject cur) {
        EObject container = cur.eContainer();
        if (container != null) {
            EList siblings = (EList)container.eGet(cur.eContainingFeature());
            int oldPosition = siblings.indexOf((Object)cur);
            int newPosition = oldPosition + 1;
            if (newPosition > siblings.size() - 1) {
                newPosition = siblings.size() - 1;
            }
            siblings.move(newPosition, (Object)cur);
        }
        return cur;
    }

    public boolean isAccessible(String path) {
        IFile file;
        boolean res = path != null ? (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path))).exists() && file.isAccessible() : false;
        return res;
    }

    public String selectIcon(String targetPath) {
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(targetPath));
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setText("Select icon");
        fileDialog.setFileName(targetFile.getLocation().toOSString());
        String[] filterExt = new String[]{"*.gif", "*.png", "*.jpg", "*.jpeg"};
        fileDialog.setFilterExtensions(filterExt);
        String source = fileDialog.open();
        if (source != null) {
            try {
                Files.copy(new File(source).toPath(), targetFile.getLocation().toFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
                targetFile.refreshLocal(2, null);
            }
            catch (IOException | CoreException e) {
                String message = String.format("An error occurred while copying %s to %s", source, targetFile.getLocation().toFile().toPath().toString());
                EcoreToolsDesignPlugin.getPlugin().log(new Status(4, "org.eclipse.emf.ecoretools.design", message, e));
            }
        }
        this.removeImageFromCache(ExtendedImageRegistry.INSTANCE, targetFile.getLocation());
        return targetPath;
    }

    private void removeImageFromCache(ExtendedImageRegistry registry, IPath targetPath) {
        try {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)targetPath.toFile().toURI().toURL());
            Field[] fieldArray = registry.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if ("table".equals(field.getName())) {
                    field.setAccessible(true);
                    Map table = (Map)field.get(registry);
                    Image image = (Image)table.remove(descriptor);
                    if (image != null) {
                        image.dispose();
                    }
                    field.setAccessible(false);
                    break;
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | MalformedURLException e) {
            EcoreToolsDesignPlugin.getPlugin().log(new Status(4, "org.eclipse.emf.ecoretools.design", "Couldn't reload icon.", (Throwable)e));
        }
    }

    class PriorityComparator<T>
    implements Comparator<T> {
        private final List<T> values;

        public PriorityComparator(List<T> values) {
            this.values = values;
        }

        @Override
        public int compare(T o1, T o2) {
            int idx1 = this.values.indexOf(o1);
            int idx2 = this.values.indexOf(o2);
            if (idx1 > -1) {
                return idx2 > -1 ? idx1 - idx2 : -1;
            }
            return idx2 > -1 ? 1 : 0;
        }
    }
}

