/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposalComputer;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlJavaCompletionProposal;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.swt.graphics.Image;

public final class JpaJpqlJavaCompletionProposalComputer
extends JpqlCompletionProposalComputer<ICompletionProposal>
implements IJavaCompletionProposalComputer {
    @Override
    ICompletionProposal buildProposal(String proposal, String displayString, String additionalInfo, Image image, int cursorOffset) {
        return new JpqlJavaCompletionProposal(this.contentAssistProposals, proposal, displayString, additionalInfo, image, this.namedQuery, this.jpqlQuery, this.tokenStart + 1, this.tokenEnd, this.position, cursorOffset);
    }

    private List<Expression> children(InfixExpression expression) {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(expression.getLeftOperand());
        children.add(expression.getRightOperand());
        children.addAll(expression.extendedOperands());
        return children;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            monitor.beginTask(null, 100);
            try {
                List<ICompletionProposal> list = this.computeCompletionProposals((JavaContentAssistInvocationContext)context, monitor);
                return list;
            }
            catch (Exception ex) {
                JptJpaUiPlugin.instance().logError(ex, JptJpaUiMessages.JPA_JPQL_JAVA_COMPLETION_PROPOSAL_COMPUTER_ERROR);
            }
            finally {
                monitor.done();
            }
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context, IProgressMonitor monitor) throws Exception {
        CompletionContext completionContext = context.getCoreContext();
        if (completionContext == null) {
            return Collections.emptyList();
        }
        int[] tokenStart = new int[]{completionContext.getTokenStart()};
        int[] tokenEnd = new int[]{completionContext.getTokenEnd()};
        if (tokenStart[0] == -1) {
            return Collections.emptyList();
        }
        int[] position = new int[]{completionContext.getOffset() - tokenStart[0] - 1};
        if (position[0] < 0) {
            return Collections.emptyList();
        }
        ICompilationUnit compilationUnit = context.getCompilationUnit();
        if (compilationUnit == null) {
            return Collections.emptyList();
        }
        CompilationUnit astRoot = ASTTools.buildASTRoot((ICompilationUnit)compilationUnit);
        IFile file = this.getCorrespondingResource(compilationUnit);
        if (file == null) {
            return Collections.emptyList();
        }
        JpaFile jpaFile = (JpaFile)file.getAdapter(JpaFile.class);
        if (jpaFile == null) {
            return Collections.emptyList();
        }
        monitor.worked(80);
        this.checkCanceled(monitor);
        NamedQuery namedQuery = this.namedQuery(jpaFile, tokenStart[0]);
        if (namedQuery == null) {
            return Collections.emptyList();
        }
        String jpqlQuery = this.retrieveQuery(astRoot, tokenStart, tokenEnd, position);
        return this.buildProposals(namedQuery, jpqlQuery, tokenStart[0], tokenEnd[0], position[0], this.getResourceManager());
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    private NamedQuery findNamedQuery(JpaStructureNode structureNode, int tokenStart) {
        if (structureNode instanceof JavaPersistentType) {
            JavaPersistentType persistentType = (JavaPersistentType)structureNode;
            JavaTypeMapping typeMapping = persistentType.getMapping();
            for (Query query : typeMapping.getQueries()) {
                if (!query.getQueryType().equals(NamedQuery.class)) continue;
                JavaNamedQuery namedQuery = (JavaNamedQuery)query;
                for (TextRange textRange : namedQuery.getQueryAnnotation().getQueryTextRanges()) {
                    if (textRange == null || !textRange.includes(tokenStart)) continue;
                    return namedQuery;
                }
            }
        }
        return null;
    }

    private IFile getCorrespondingResource(ICompilationUnit compilationUnit) {
        try {
            return (IFile)compilationUnit.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptJpaUiPlugin.instance().logError(ex);
            return null;
        }
    }

    private boolean isInsideNode(ASTNode node, int tokenStart, int tokenEnd) {
        int startPosition = node.getStartPosition();
        return startPosition <= tokenStart && startPosition + node.getLength() >= tokenEnd;
    }

    @Override
    String modifyJpqlQuery(String jpqlQuery, int[] position) {
        return ExpressionTools.unescape((CharSequence)jpqlQuery, (int[])position);
    }

    private NamedQuery namedQuery(JpaFile jpaFile, int tokenStart) {
        for (JpaStructureNode node : jpaFile.getRootStructureNodes()) {
            NamedQuery namedQuery = this.findNamedQuery(node, tokenStart);
            if (namedQuery == null) continue;
            return namedQuery;
        }
        return null;
    }

    private String retrieveQuery(CompilationUnit astRoot, int[] tokenStart, int[] tokenEnd, int[] position) {
        for (AbstractTypeDeclaration type : astRoot.types()) {
            if (!this.isInsideNode((ASTNode)type, tokenStart[0], tokenEnd[0])) continue;
            for (IExtendedModifier modifier : type.modifiers()) {
                Annotation annotation;
                if (!modifier.isAnnotation() || !this.isInsideNode((ASTNode)(annotation = (Annotation)modifier), tokenStart[0], tokenEnd[0])) continue;
                if (annotation.isSingleMemberAnnotation()) {
                    SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
                    Expression value = singleMemberAnnotation.getValue();
                    if (value.getNodeType() == 4) {
                        ArrayInitializer array = (ArrayInitializer)value;
                        for (Expression expression : array.expressions()) {
                            if (!this.isInsideNode((ASTNode)expression, tokenStart[0], tokenEnd[0])) continue;
                            return this.retrieveQuery((NormalAnnotation)expression, tokenStart, tokenEnd, position);
                        }
                        continue;
                    }
                    NormalAnnotation childAnnotation = (NormalAnnotation)value;
                    if (!this.isInsideNode((ASTNode)childAnnotation, tokenStart[0], tokenEnd[0])) continue;
                    return this.retrieveQuery(childAnnotation, tokenStart, tokenEnd, position);
                }
                if (!annotation.isNormalAnnotation()) continue;
                return this.retrieveQuery((NormalAnnotation)annotation, tokenStart, tokenEnd, position);
            }
        }
        return null;
    }

    private String retrieveQuery(NormalAnnotation annotation, int[] tokenStart, int[] tokenEnd, int[] position) {
        for (MemberValuePair pair : annotation.values()) {
            Expression expression = pair.getValue();
            if (!this.isInsideNode((ASTNode)expression, tokenStart[0], tokenEnd[0])) continue;
            Expression child = pair.getValue();
            if (child.getNodeType() == 45) {
                StringLiteral literal = (StringLiteral)pair.getValue();
                return this.unquotedString(literal.getEscapedValue());
            }
            if (child.getNodeType() != 27) continue;
            StringBuilder sb = new StringBuilder();
            boolean adjustPosition = true;
            for (Expression childNode : this.children((InfixExpression)child)) {
                StringLiteral literal = (StringLiteral)childNode;
                sb.append(this.unquotedString(literal.getEscapedValue()));
                if (adjustPosition && !this.isInsideNode((ASTNode)literal, tokenEnd[0], tokenEnd[0])) {
                    position[0] = position[0] + (literal.getLength() - 2);
                    continue;
                }
                adjustPosition = false;
            }
            tokenStart[0] = child.getStartPosition();
            tokenEnd[0] = child.getStartPosition() + child.getLength() - 1;
            return sb.toString();
        }
        return "";
    }

    private String unquotedString(String value) {
        if (value == null) {
            value = "";
        } else if (StringTools.isQuoted((String)value)) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

