/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.SerializableTLDNamespace;
import org.osgi.framework.Version;

class MasterIndex
implements Serializable {
    public static final SerializableVersion CURRENT_VERSION = new SerializableVersion(1, 0, 0);
    private static final long serialVersionUID = -2725662604972649316L;
    private final transient String _repositoryPath;
    private final transient File _storageFile;
    private IndexHeader _header;
    private List<ProjectIndex> _projectIndices;

    public MasterIndex(File storageFile, String repositoryPath) {
        this._storageFile = storageFile;
        this._repositoryPath = repositoryPath;
    }

    public synchronized void create(SerializableVersion version) throws IOException {
        if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
            JSFCoreTraceOptions.log("MasterIndex.create, version=:" + version.toString());
        }
        this._header = new IndexHeader(version);
        this._projectIndices = new ArrayList<ProjectIndex>();
        this.save(this._storageFile);
    }

    public synchronized void save(File file) throws IOException {
        try (FileOutputStream out = null;){
            if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                JSFCoreTraceOptions.log("Trying to save master index file: " + file.getAbsolutePath());
            }
            out = new FileOutputStream(file);
            ObjectOutputStream objStream = new ObjectOutputStream(out);
            objStream.writeObject(this);
            if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                JSFCoreTraceOptions.log("Master index file written successfully: " + file.getAbsolutePath());
            }
        }
    }

    public synchronized void load(SerializableVersion expectedVersion) throws IOException, ClassNotFoundException {
        try (FileInputStream in = null;){
            if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                JSFCoreTraceOptions.log("Trying to load master index file: " + this._storageFile.getAbsolutePath());
            }
            in = new FileInputStream(this._storageFile);
            ObjectInputStream objStream = new ObjectInputStream(in);
            MasterIndex index = (MasterIndex)objStream.readObject();
            this._header = index._header;
            this._projectIndices = index._projectIndices;
            if (JSFCoreTraceOptions.TRACE_JSPTAGPERSISTENCE) {
                JSFCoreTraceOptions.log("Loaded master index file successfully:" + this._storageFile.getAbsolutePath());
                JSFCoreTraceOptions.log("Initial contents: ");
                System.out.println(index.toString());
            }
        }
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("Header: %s\n\n", this._header.toString()));
        for (ProjectIndex projIndex : this._projectIndices) {
            buffer.append(String.format("\t%s\n", projIndex.toString()));
        }
        return buffer.toString();
    }

    public synchronized ProjectIndex getProjectIndex(IProject project) {
        ProjectIndex index = this.findIndex(project);
        if (index != null) {
            return index;
        }
        index = new ProjectIndex(0L, project.getName(), this._repositoryPath);
        index.create();
        this._projectIndices.add(index);
        try {
            this.save(this._storageFile);
        }
        catch (IOException ioe) {
            JSFCorePlugin.log(ioe, "Failed to save master index.  Project Index for " + project.toString() + " may not be saved");
        }
        return index;
    }

    public synchronized void removeProjectIndex(IProject project) throws IOException {
        ProjectIndex index = this.findIndex(project);
        if (index != null) {
            this._projectIndices.remove(index);
            if (!index.remove()) {
                throw new IOException("Failed to remove index file");
            }
        }
    }

    private ProjectIndex findIndex(IProject project) {
        for (ProjectIndex index : this._projectIndices) {
            if (!index.getProjectName().equals(project.getName())) continue;
            return index;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._header);
        out.writeObject(this._projectIndices);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._header = (IndexHeader)in.readObject();
        this._projectIndices = (List)in.readObject();
    }

    private class IndexHeader
    implements Serializable {
        private static final long serialVersionUID = 40851054201507727L;
        private final SerializableVersion _version;

        public IndexHeader(SerializableVersion version) {
            this._version = version;
        }

        public String toString() {
            return "Version: " + this._version.toString();
        }
    }

    static class ProjectIndex
    implements Serializable {
        private static final long serialVersionUID = 2864798175910805380L;
        private final String _projectName;
        private final String _relativePath;
        private final long _lastModStampOnProject;
        private File _file;

        public ProjectIndex(long lastModStampOnProject, String projectName, String relativePath) {
            this._lastModStampOnProject = lastModStampOnProject;
            this._projectName = projectName;
            this._relativePath = relativePath;
        }

        public boolean remove() {
            return this._file.delete();
        }

        public synchronized void create() {
            long uniqueCode = Math.round(Math.random() * 2.147483647E9);
            String fileName = String.format("Project_%s_%x.idx", this._projectName, uniqueCode);
            this._file = new File(new Path(this._relativePath).append(fileName).toOSString());
        }

        public synchronized Map<String, SerializableTLDNamespace> getNamespaces() throws IOException, ClassNotFoundException {
            try (FileInputStream in = null;){
                Map namespaces;
                in = new FileInputStream(this._file);
                ObjectInputStream objStream = new ObjectInputStream(in);
                Map map = namespaces = (Map)objStream.readObject();
                return map;
            }
        }

        public synchronized void save(Map<String, SerializableTLDNamespace> namespaces) throws IOException {
            try (FileOutputStream out = null;){
                out = new FileOutputStream(this._file);
                ObjectOutputStream objStream = new ObjectOutputStream(out);
                objStream.writeObject(namespaces);
            }
        }

        public String toString() {
            return "project= " + this._projectName + ", relativePath=" + this._relativePath + ", lastModified=" + this._lastModStampOnProject + ", saveFile=" + this._file;
        }

        protected final String getProjectName() {
            return this._projectName;
        }

        protected final String getRelativePath() {
            return this._relativePath;
        }

        protected final long getLastModStampOnProject() {
            return this._lastModStampOnProject;
        }
    }

    static class SerializableVersion
    implements Serializable {
        private Version _version;
        private static final long serialVersionUID = 5973410328814890568L;

        public SerializableVersion(int major, int minor, int micro) {
            this._version = new Version(major, minor, micro);
        }

        public SerializableVersion(String versionString) {
            this._version = new Version(versionString);
        }

        public Version getVersion() {
            return this._version;
        }

        public String toString() {
            return this._version.toString();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this._version.toString());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            String versionString = (String)in.readObject();
            this._version = new Version(versionString);
        }
    }
}

