/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCoreMessages;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class WSDL2JavaProjectSelectionCommand
extends AbstractDataModelOperation {
    private WSDL2JavaDataModel model;
    private IProject initialProject;
    private IProject serverProject;
    private IProject currentProject;

    public WSDL2JavaProjectSelectionCommand(WSDL2JavaDataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        if (this.currentProject == null && this.initialProject == null && this.serverProject != null) {
            status = Status.OK_STATUS;
            this.model.setProjectName(this.serverProject.getName());
            return status;
        }
        if (this.currentProject == null && this.initialProject != null && !this.initialProject.equals((Object)this.serverProject)) {
            status = new Status(2, "org.eclipse.jst.ws.cxf.core", CXFCreationCoreMessages.bind((String)CXFCreationCoreMessages.WSDL2JAVA_PROJECT_SELECTION_ERROR, (Object[])new Object[]{this.serverProject.getName(), this.initialProject.getName()}));
        } else if (this.initialProject == null && this.currentProject != null && !this.currentProject.equals((Object)this.serverProject)) {
            status = new Status(2, "org.eclipse.jst.ws.cxf.core", CXFCreationCoreMessages.bind((String)CXFCreationCoreMessages.WSDL2JAVA_PROJECT_SELECTION_ERROR, (Object[])new Object[]{this.serverProject.getName(), this.currentProject.getName()}));
        } else if (this.initialProject != null && this.currentProject != null && !this.currentProject.equals((Object)this.serverProject)) {
            status = new Status(2, "org.eclipse.jst.ws.cxf.core", CXFCreationCoreMessages.bind((String)CXFCreationCoreMessages.WSDL2JAVA_PROJECT_SELECTION_ERROR, (Object[])new Object[]{this.serverProject.getName(), this.currentProject.getName()}));
        } else if (this.serverProject != null && this.serverProject.getProject() != null) {
            this.model.setProjectName(this.serverProject.getProject().getName());
            status = Status.OK_STATUS;
        }
        if (!status.isOK()) {
            try {
                this.getEnvironment().getStatusHandler().report(status);
            }
            catch (StatusException statusException) {
                return new Status(4, "org.eclipse.jst.ws.cxf.core", 0, "", null);
            }
        }
        return status;
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }

    public void setInitialProject(IProject project) {
        this.initialProject = project;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
    }
}

