/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.linuxtools.changelog.core.IEditorChangeLogContrib;
import org.eclipse.linuxtools.internal.changelog.core.editors.ChangeLogFormattingStrategy;
import org.eclipse.linuxtools.internal.changelog.core.editors.GNUPartitionScanner;
import org.eclipse.linuxtools.internal.changelog.core.editors.GNUPresentationReconciler;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class GNUEditorConfiguration
extends TextSourceViewerConfiguration
implements IEditorChangeLogContrib {
    public static final String CHANGELOG_PARTITIONING = "gnu_changelog_partitioning";

    @Override
    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "changelog_email", "changelog_src_entry"};
    }

    @Override
    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return this.getRegisteredHyperlinkDetectors(sourceViewer);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return CHANGELOG_PARTITIONING;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter cf = new ContentFormatter();
        cf.enablePartitionAwareFormatting(false);
        ChangeLogFormattingStrategy cfs = new ChangeLogFormattingStrategy();
        cf.setFormattingStrategy((IFormattingStrategy)cfs, "__dftl_partition_content_type");
        return cf;
    }

    @Override
    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return new GNUPresentationReconciler();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setup(IDocument document) {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new GNUPartitionScanner(), GNUPartitionScanner.CHANGELOG_PARTITION_TYPES);
        partitioner.connect(document);
        IDocument iDocument = document;
        if (iDocument instanceof IDocumentExtension3) {
            void extension3;
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            IDocumentExtension3 cfr_ignored_0 = (IDocumentExtension3)iDocument;
            extension3.setDocumentPartitioner(CHANGELOG_PARTITIONING, (IDocumentPartitioner)partitioner);
        } else {
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
    }
}

