/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.repository.LocalArtifactRepository;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.GenericVersionConstraint;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.IWorkspaceClassifierResolver;

public final class EclipseWorkspaceArtifactRepository
extends LocalArtifactRepository
implements WorkspaceReader {
    private static final String POM_EXTENSION = "pom";
    private static final GenericVersionScheme versionScheme = new GenericVersionScheme();
    private final transient ProjectRegistryManager.Context context;
    private static final ThreadLocal<Boolean> disabled = new ThreadLocal();
    private final WorkspaceRepository workspaceRepository;

    public EclipseWorkspaceArtifactRepository(ProjectRegistryManager.Context context) {
        this.context = context;
        this.workspaceRepository = new WorkspaceRepository("ide", ((Object)((Object)this)).getClass());
    }

    protected File resolveAsEclipseProject(String groupId, String artifactId, String baseVersion, String classifier, String extension) {
        if (EclipseWorkspaceArtifactRepository.isDisabled()) {
            return null;
        }
        if (this.context == null) {
            return null;
        }
        IFile pom = this.getWorkspaceArtifact(groupId, artifactId, baseVersion);
        if (pom == null || !pom.isAccessible()) {
            return null;
        }
        if (this.context.pom != null && pom.equals((Object)this.context.pom) && !POM_EXTENSION.equals(extension)) {
            return null;
        }
        if (this.context.resolverConfiguration.isResolveWorkspaceProjects()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath file = pom.getLocation();
            if (file == null) {
                return ProjectRegistryManager.toJavaIoFile(pom);
            }
            if (!POM_EXTENSION.equals(extension)) {
                IResource res;
                MavenProjectFacade facade = this.context.state.getProjectFacade(pom);
                IWorkspaceClassifierResolver resolver = MavenPlugin.getWorkspaceClassifierResolverManager().getResolver();
                IPath location = resolver.resolveClassifier(facade, classifier);
                if (location == null) {
                    location = facade.getOutputLocation();
                }
                if (location != null && (res = root.findMember(location)) != null) {
                    file = res.getLocation();
                }
            }
            return file.toFile();
        }
        return null;
    }

    private IFile getWorkspaceArtifact(String groupId, String artifactId, String version) {
        GenericVersionConstraint constraint;
        Map<ArtifactKey, Collection<IFile>> workspaceArtifacts = this.context.state.getWorkspaceArtifacts(groupId, artifactId);
        if (workspaceArtifacts.isEmpty()) {
            return null;
        }
        try {
            constraint = versionScheme.parseVersionConstraint(version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        TreeMap<GenericVersion, ArtifactKey> matchingArtifacts = new TreeMap<GenericVersion, ArtifactKey>();
        for (ArtifactKey workspaceArtifact : workspaceArtifacts.keySet()) {
            try {
                GenericVersion workspaceVersion = versionScheme.parseVersion(workspaceArtifact.version());
                if (!constraint.containsVersion((Version)workspaceVersion)) continue;
                matchingArtifacts.put(workspaceVersion, workspaceArtifact);
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
        if (matchingArtifacts.isEmpty()) {
            return null;
        }
        ArtifactKey matchingArtifact = (ArtifactKey)matchingArtifacts.values().iterator().next();
        return workspaceArtifacts.get(matchingArtifact).iterator().next();
    }

    public File findArtifact(Artifact artifact) {
        return this.resolveAsEclipseProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getClassifier(), artifact.getExtension());
    }

    public org.apache.maven.artifact.Artifact find(org.apache.maven.artifact.Artifact artifact) {
        File file = this.resolveAsEclipseProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getClassifier(), artifact.getType());
        if (file != null) {
            artifact.setFile(file);
            artifact.setResolved(true);
        }
        return artifact;
    }

    public boolean hasLocalMetadata() {
        return false;
    }

    public static Disabled setDisabled() {
        boolean isDisabled = EclipseWorkspaceArtifactRepository.isDisabled();
        disabled.set(true);
        return () -> disabled.set(isDisabled);
    }

    public static boolean isDisabled() {
        return Boolean.TRUE.equals(disabled.get());
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof EclipseWorkspaceArtifactRepository;
    }

    public List<String> findVersions(Artifact artifact) {
        return this.findVersions(artifact.getGroupId(), artifact.getArtifactId());
    }

    public List<String> findVersions(org.apache.maven.artifact.Artifact artifact) {
        return this.findVersions(artifact.getGroupId(), artifact.getArtifactId());
    }

    private List<String> findVersions(String groupId, String artifactId) {
        ArrayList<String> versions = new ArrayList<String>();
        if (EclipseWorkspaceArtifactRepository.isDisabled()) {
            return versions;
        }
        if (this.context == null) {
            return versions;
        }
        for (MavenProjectFacade facade : this.context.state.getProjects()) {
            ArtifactKey artifactKey = facade.getArtifactKey();
            if (!groupId.equals(artifactKey.groupId()) || !artifactId.equals(artifactKey.artifactId())) continue;
            versions.add(artifactKey.version());
        }
        return versions;
    }

    public WorkspaceRepository getRepository() {
        return this.workspaceRepository;
    }

    public static interface Disabled
    extends AutoCloseable {
        @Override
        public void close();
    }
}

