/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.completion.parser.LightweightParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOLexer;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitorImpl;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.vm.ASTElementContextEnv;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.parser.OCLLexer;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.Visitor;

public class ConditionChecker {
    public static final int ERR_CODE_COMPILATION = 100;
    public static final int ERR_CODE_EVALUATION = 110;
    private final String fConditionBody;
    private final ASTNode fTargetASTElement;
    private OCLExpression<EClassifier> fConditionAST;
    private IStatus fConditionError;

    public ConditionChecker(String conditionBody, ASTNode targetASTElement) {
        if (conditionBody == null || targetASTElement == null) {
            throw new IllegalArgumentException();
        }
        this.fConditionBody = conditionBody;
        this.fTargetASTElement = targetASTElement;
    }

    public Object evaluate(QvtOperationalEvaluationVisitorImpl mainEvaluator) throws CoreException {
        OCLExpression<EClassifier> condition = this.getConditionAST();
        if (this.fConditionError != null) {
            throw new CoreException(this.fConditionError);
        }
        assert (condition != null);
        QvtOperationalEvaluationEnv evalEnv = mainEvaluator.getOperationalEvaluationEnv().cloneEvaluationEnv();
        QvtOperationalEvaluationVisitorImpl dedicatedVisitor = new QvtOperationalEvaluationVisitorImpl((QvtOperationalEnv)mainEvaluator.getEnvironment(), evalEnv);
        try {
            return condition.accept((Visitor)dedicatedVisitor);
        }
        catch (Throwable e) {
            throw new CoreException(QVTODebugCore.createError(e.toString(), 110, e));
        }
    }

    public boolean checkCondition(QvtOperationalEvaluationVisitorImpl mainEvaluator) throws CoreException {
        return Boolean.TRUE.equals(this.evaluate(mainEvaluator));
    }

    public EClassifier getConditionType() {
        if (this.fConditionAST != null) {
            return (EClassifier)this.fConditionAST.getType();
        }
        return null;
    }

    private ASTElementContextEnv getEnvironmentForASTElement() {
        QvtOperationalEnvFactory factory = new QvtOperationalEnvFactory();
        QvtOperationalEnv rootEnv = null;
        ASTNode moduleContext = this.fTargetASTElement;
        while (moduleContext != null) {
            if (moduleContext instanceof Module) {
                rootEnv = QVTODebugUtil.getEnvironment((Module)moduleContext);
                break;
            }
            moduleContext = moduleContext.eContainer();
        }
        if (rootEnv == null) {
            rootEnv = factory.createEnvironment();
        }
        QvtOperationalEnv contextEnv = null;
        ASTNode operContext = this.fTargetASTElement;
        while (operContext != null) {
            if (operContext instanceof EOperation) {
                contextEnv = factory.createOperationContext((Environment)rootEnv, (EOperation)operContext);
            }
            operContext = operContext.eContainer();
        }
        if (contextEnv == null) {
            contextEnv = rootEnv;
        }
        ASTElementContextEnv targetContextEnv = new ASTElementContextEnv(contextEnv, (EObject)this.fTargetASTElement);
        return targetContextEnv;
    }

    private OCLExpression<EClassifier> getConditionAST() {
        if (this.fConditionError != null) {
            return null;
        }
        if (this.fConditionAST == null) {
            this.fConditionAST = this.analyzeCondition();
        }
        return this.fConditionAST;
    }

    private OCLExpressionCS parseCondition(QvtOperationalEnv env) {
        try {
            QVTOLexer lexer = new QVTOLexer((Environment)env, new OCLInput(this.fConditionBody).getContent());
            LightweightParser parser = new LightweightParser(lexer);
            parser.enableCSTTokens(true);
            parser.getIPrsStream().resetTokenStream();
            lexer.lexer(parser.getIPrsStream());
            CSTNode cst = parser.parser(10);
            if (cst instanceof OCLExpressionCS) {
                return (OCLExpressionCS)cst;
            }
            env.reportError("Not an OCL expression", -1, -1);
        }
        catch (ParserException ex) {
            env.reportError(ex.toString(), -1, -1);
        }
        return null;
    }

    private OCLExpression<EClassifier> analyzeCondition() {
        ASTElementContextEnv env = this.getEnvironmentForASTElement();
        OCLExpressionCS conditionCS = this.parseCondition(env);
        OCLExpression ast = null;
        if (conditionCS != null && !env.hasErrors()) {
            OCLLexer oclLexer = new OCLLexer((Environment)env, new char[0]);
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setReportErrors(true);
            options.setShowAnnotations(false);
            options.setSourceLineNumbersEnabled(false);
            try {
                QvtOperationalVisitorCS visitor = new QvtOperationalVisitorCS(oclLexer, options);
                ast = visitor.analyzeExpressionCS(conditionCS, (Environment)env);
                if (ast == null) {
                    env.reportError("Invalid expression", (CSTNode)conditionCS);
                }
            }
            catch (Throwable e) {
                this.fConditionError = QVTODebugCore.createError("Failed to parse condition", 100, e);
                QVTODebugCore.log(e);
                return null;
            }
        }
        if (env.hasErrors()) {
            this.fConditionError = QVTODebugCore.createError(env.getErrorTxtBuffer().toString(), 100, null);
        }
        return ast;
    }
}

