/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMIResource;

public class ExeXMISerializer {
    public static final String COMPILED_XMI_FILE_EXTENSION = "qvtox";

    public static URI toSourceUnitURI(URI uri) {
        return uri.trimFileExtension().appendFileExtension("qvto");
    }

    public static URI toXMIUnitURI(URI uri) {
        return uri.trimFileExtension().appendFileExtension(COMPILED_XMI_FILE_EXTENSION);
    }

    public static void saveUnitXMI(CompiledUnit[] units, EPackage.Registry metamodelRegistry) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setPackageRegistry(metamodelRegistry);
        CompiledUnit[] compiledUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            CompiledUnit nextUnit = compiledUnitArray[n2];
            if (nextUnit.getUnitCST() != null && !nextUnit.getModuleEnvironments().isEmpty()) {
                URI uri = nextUnit.getURI();
                URI xmiUnitURI = ExeXMISerializer.toXMIUnitURI(uri);
                ExeXMIResource xmiUnitResource = new ExeXMIResource(xmiUnitURI);
                rs.getResources().add((Object)xmiUnitResource);
                for (QvtOperationalModuleEnv nextModuleEnv : nextUnit.getModuleEnvironments()) {
                    Resource unitResource = nextModuleEnv.getTypeResolver().getResource();
                    unitResource.setURI(xmiUnitURI);
                    xmiUnitResource.getContents().addAll((Collection)unitResource.getContents());
                }
            }
            ++n2;
        }
        for (Resource next : rs.getResources()) {
            next.save(Collections.EMPTY_MAP);
            URI savedXMIURI = next.getURI();
            URI srcURI = ExeXMISerializer.toSourceUnitURI(savedXMIURI);
            Map options = Collections.emptyMap();
            Map xmiAttrs = URIConverter.INSTANCE.getAttributes(savedXMIURI, options);
            HashMap xmiNewAttributes = new HashMap(xmiAttrs);
            Object srcFileTimeStmp = URIConverter.INSTANCE.getAttributes(srcURI, options).get("timeStamp");
            xmiNewAttributes.put("timeStamp", srcFileTimeStmp);
            URIConverter.INSTANCE.setAttributes(savedXMIURI, xmiNewAttributes, options);
            if (next.getErrors().isEmpty()) continue;
            Diagnostic diagnostic = EcoreUtil.computeDiagnostic((Resource)next, (boolean)false);
            QvtPlugin.logDiagnostic(diagnostic);
        }
    }
}

