/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractDiagramHandler;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractDiagramActionHandler
extends AbstractDiagramHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ActionManager manager = this.getActionManager();
        if (manager != null) {
            IAction globalActionHandler = this.getGlobalActionHandler();
            if (globalActionHandler instanceof IActionWithProgress) {
                ((IActionWithProgress)globalActionHandler).refresh();
                manager.run((IActionWithProgress)globalActionHandler);
            } else if (globalActionHandler != null) {
                globalActionHandler.runWithEvent(null);
            }
        }
        return null;
    }

    private IAction getGlobalActionHandler() {
        IDiagramWorkbenchPart workbenchPart = this.getDiagramWorkbenchPart();
        if (workbenchPart instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)workbenchPart;
            IAction action = editor.getEditorSite().getActionBars().getGlobalActionHandler(this.getActionId());
            return action;
        }
        return null;
    }

    private ActionManager getActionManager() {
        IDiagramWorkbenchPart part = this.getDiagramWorkbenchPart();
        if (part != null) {
            return (ActionManager)part.getAdapter(ActionManager.class);
        }
        return null;
    }

    protected abstract String getActionId();

    public void setEnabled(Object evaluationContext) {
        IAction action = this.getGlobalActionHandler();
        if (action instanceof IActionWithProgress) {
            ((IActionWithProgress)action).refresh();
            this.setBaseEnabled(((IActionWithProgress)action).isRunnable());
        } else if (action != null) {
            this.setBaseEnabled(action.isEnabled());
        } else {
            this.setBaseEnabled(false);
        }
    }
}

