/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AutomaticNotationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.canonical.DefaultUMLVisualChildrenStrategy;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateStereotypeLabelCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayConstant;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeMigrationHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AbstractAppliedStereotypeDisplayEditPolicy
extends GraphicalEditPolicyEx
implements AutomaticNotationEditPolicy,
NotificationListener,
IPapyrusListener {
    private static final String VISIBLE = "visible";
    private static final String E_ANNOTATIONS = "eAnnotations";
    protected String EMPTY_STRING = "";
    public static final String STEREOTYPE_LABEL_POLICY = "AppliedStereotypeDisplayEditPolicy";
    protected Element hostSemanticElement;
    protected StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
    protected StereotypeMigrationHelper migrationHelper = StereotypeMigrationHelper.getInstance();
    protected IGraphicalEditPart hostEditPart;
    protected View hostView = null;
    protected List<Stereotype> stereotypeList = Collections.emptyList();
    private final NotificationPreCommitListener precommitListener = this::handlePrecommit;

    static {
        DefaultUMLVisualChildrenStrategy.registerExcludedViewTypes(StereotypeDisplayConstant.APPLIED_STEREOTYPE_VIEW_TYPES);
    }

    public void activate() {
        if (this.getHost() instanceof IGraphicalEditPart) {
            this.initialisation();
            this.subscribe((EObject)this.hostSemanticElement);
            this.subscribe((EObject)this.hostView);
            this.refreshNotationStructure();
        }
    }

    protected void subscribe(EObject notifier) {
        this.getDiagramEventBroker().addNotificationListener(notifier, this.precommitListener);
    }

    protected void unsubscribe(EObject notifier) {
        this.getDiagramEventBroker().removeNotificationListener(notifier, this.precommitListener);
    }

    private void initialisation() {
        this.hostEditPart = (IGraphicalEditPart)this.getHost();
        this.hostSemanticElement = this.getUMLElement();
        this.hostView = this.hostEditPart.getNotationView();
        this.stereotypeList = this.hostSemanticElement != null ? this.hostSemanticElement.getAppliedStereotypes() : Collections.emptyList();
    }

    public void refresh() {
        this.initialisation();
        this.refreshDisplay();
    }

    public abstract void refreshDisplay();

    private Command handlePrecommit(final Notification notification) {
        return new RecordingCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain()){

            protected void doExecute() {
                AbstractAppliedStereotypeDisplayEditPolicy.this.notifyChanged(notification);
            }
        };
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        Node notifier = null;
        if (notification.getNotifier() instanceof Node) {
            notifier = (Node)notification.getNotifier();
        }
        if (eventType == 31) {
            this.initialisation();
            this.refreshNotationStructure();
        } else if (eventType == 32) {
            this.initialisation();
            this.refreshNotationStructure();
        }
        if (this.isConcerned(notification)) {
            if (this.helper.isInStereotypeComment(notifier)) {
                this.refreshCommentContainer();
            } else {
                this.refreshHost();
            }
        }
    }

    private void refreshHost() {
        if (this.hostEditPart != null) {
            this.hostEditPart.refresh();
        }
    }

    private void refreshCommentContainer() {
        if (this.hostEditPart != null && this.hostEditPart.getParent() != null) {
            if (this.hostEditPart instanceof ConnectionEditPart) {
                ((ConnectionEditPart)this.hostEditPart).getTarget().getParent().refresh();
                ((ConnectionEditPart)this.hostEditPart).getSource().getParent().refresh();
            } else {
                this.hostEditPart.getParent().refresh();
            }
        }
    }

    private boolean isConcerned(Notification notification) {
        boolean concerned = false;
        if (this.helper.isStereotypeView(notification.getNotifier())) {
            if (3 == notification.getEventType() && notification.getFeature() instanceof EStructuralFeature) {
                concerned = ((EStructuralFeature)notification.getFeature()).getName().equals(E_ANNOTATIONS);
            } else if (1 == notification.getEventType() && notification.getFeature() instanceof EStructuralFeature) {
                concerned = ((EStructuralFeature)notification.getFeature()).getName().equals(VISIBLE);
            }
        } else if (notification.getNotifier() instanceof NamedStyle) {
            NamedStyle style = (NamedStyle)notification.getNotifier();
            concerned = "depth".equals(style.getName()) && this.helper.isStereotypeView(style.eContainer());
        }
        return concerned;
    }

    public void refreshNotationStructure() {
        if (this.hostView != null) {
            this.removeUnappliedStereotypes(this.hostView);
            if (!this.stereotypeList.isEmpty()) {
                this.refreshStereotypeStructure();
            }
        }
    }

    public void refreshStereotypeStructure() {
        if (!this.stereotypeList.isEmpty()) {
            for (Stereotype stereotype : this.stereotypeList) {
                this.refreshStereotypeLabelStructure(stereotype);
                this.refreshStereotypeBraceStructure(stereotype);
            }
        }
    }

    public void refreshStereotypeBraceStructure(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeBraceCompartment(this.hostView, stereotype);
        if (compartment == null) {
            this.createAppliedStereotypeBraceCompartment(stereotype);
            this.subscribe((EObject)this.helper.getStereotypeBraceCompartment(this.hostView, stereotype));
        }
        this.createAppliedStereotypeBraceProperties(stereotype);
    }

    public void refreshStereotypeLabelStructure(Stereotype stereotype) {
        DecorationNode label = this.helper.getStereotypeLabel(this.hostView, stereotype);
        if (label == null) {
            this.createAppliedStereotypeLabel(stereotype);
            this.subscribe((EObject)this.helper.getStereotypeLabel(this.hostView, stereotype));
        }
    }

    public Image stereotypeIconToDisplay() {
        Image icon = null;
        boolean displayIcon = NotationUtils.getBooleanValue((View)this.hostView, (String)"displayIcon", (boolean)false);
        if (displayIcon) {
            Iterator stereotypeIterator = this.getUMLElement().getAppliedStereotypes().iterator();
            while (stereotypeIterator.hasNext() && icon == null) {
                Stereotype appliedStereotype = (Stereotype)stereotypeIterator.next();
                icon = Activator.getIconElement(this.getUMLElement(), appliedStereotype, false);
            }
        }
        return icon;
    }

    protected void createAppliedStereotypeLabel(Stereotype stereotype) {
        View node = this.hostEditPart.getNotationView();
        if (!this.helper.isLabelExist(node, stereotype)) {
            this.executeStereotypeLabelCreation(this.hostEditPart, stereotype);
        }
    }

    protected void createAppliedStereotypeBraceCompartment(Stereotype stereotype) {
        View node = this.hostEditPart.getNotationView();
        if (!this.helper.isBraceCompartmentExist(node, stereotype)) {
            this.executeAppliedStereotypeBraceCompartmentCreation(this.hostEditPart, stereotype);
        }
    }

    protected void createAppliedStereotypeBraceProperties(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeBraceCompartment(this.hostEditPart.getNotationView(), stereotype);
        if (compartment != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                this.createAppliedStereotypeBraceProperty((Node)compartment, property);
                this.subscribe((EObject)this.helper.getStereotypePropertyInBrace(this.hostView, stereotype, property));
            }
        }
    }

    protected void createAppliedStereotypeBraceProperty(Node compartment, Property property) {
        if (property != null && !property.getName().startsWith("base_") && !this.helper.isBracePropertyExist(compartment, property)) {
            this.executeAppliedStereotypeBracePropertyViewCreation(this.hostEditPart, compartment, property);
        }
    }

    protected void removeUnappliedStereotypes(View view) {
        if (view != null) {
            ArrayList children = new ArrayList(view.getChildren());
            for (Object child : children) {
                if (!this.helper.isStereotypeView(child) || !(((View)child).getElement() instanceof Stereotype)) continue;
                Stereotype childStereotype = (Stereotype)((View)child).getElement();
                if (this.hostSemanticElement == null || this.hostSemanticElement.isStereotypeApplied(childStereotype)) continue;
                this.executeStereotypeViewRemove(this.hostEditPart, (View)child);
            }
        }
    }

    protected void executeAppliedStereotypeBraceCompartmentCreation(IGraphicalEditPart editPart, Stereotype stereotype) {
        CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(editPart.getEditingDomain(), editPart.getNotationView(), stereotype, "StereotypeBrace");
        this.execute((Command)command);
    }

    protected void executeAppliedStereotypeBracePropertyViewCreation(IGraphicalEditPart editPart, Node compartment, Property stereotypeProperty) {
        CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(editPart.getEditingDomain(), (View)compartment, stereotypeProperty, "StereotypePropertyBrace");
        this.execute((Command)command);
    }

    protected void executeStereotypeLabelCreation(IGraphicalEditPart editPart, Stereotype stereotype) {
        CreateStereotypeLabelCommand command = new CreateStereotypeLabelCommand(editPart.getEditingDomain(), editPart.getNotationView(), stereotype);
        this.execute((Command)command);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected Element getUMLElement() {
        EObject element = this.getView().getElement();
        if (element instanceof Element) {
            return (Element)element;
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected void executeStereotypeViewRemove(IGraphicalEditPart editPart, View view) {
        DeleteCommand command = new DeleteCommand(view);
        this.execute((ICommand)command);
    }

    public void deactivate() {
        this.removeListener();
    }

    public void removeListener() {
        View view = this.getView();
        if (view != null) {
            this.unsubscribe((EObject)view);
            if (this.hostSemanticElement != null) {
                for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
                    this.unsubscribe(stereotypeApplication);
                }
                this.unsubscribe((EObject)this.hostSemanticElement);
                this.hostSemanticElement = null;
            }
        }
        if (!this.stereotypeList.isEmpty()) {
            for (Stereotype stereotype : this.stereotypeList) {
                BasicCompartment compartment;
                DecorationNode label = this.helper.getStereotypeLabel(this.hostView, stereotype);
                if (label != null) {
                    this.unsubscribe((EObject)label);
                }
                if ((compartment = this.helper.getStereotypeBraceCompartment(this.hostView, stereotype)) != null) {
                    this.subscribe((EObject)this.helper.getStereotypeBraceCompartment(this.hostView, stereotype));
                }
                if (compartment == null || stereotype == null) continue;
                EList properties = stereotype.allAttributes();
                for (Property property : properties) {
                    this.unsubscribe((EObject)this.helper.getStereotypePropertyInBrace(this.hostView, stereotype, property));
                }
            }
        }
    }
}

