/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.api.tools.internal.AnyValue;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.model.WorkspaceBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.internal.core.BuildDependencyCollector;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ApiBaseline
extends ApiElement
implements IApiBaseline,
IVMInstallChangedListener {
    private static final IApiComponent[] EMPTY_COMPONENTS = new IApiComponent[0];
    private volatile State fState;
    private String fExecutionEnvironment;
    private ArrayList<IApiComponent> fSystemLibraryComponentList = new ArrayList();
    private boolean fAutoResolve = true;
    private String fLocation;
    private IStatus fEEStatus = null;
    private AnyValue ANY_VALUE = new AnyValue("*");
    private final Map<String, Map<IApiComponent, IApiComponent[]>> fComponentsProvidingPackageCache = new ConcurrentHashMap<String, Map<IApiComponent, IApiComponent[]>>(8);
    private volatile Map<String, IApiComponent> fComponentsById;
    private volatile Map<String, Set<IApiComponent>> fAllComponentsById;
    private volatile Map<String, IApiComponent> fComponentsByProjectNames;
    private HashSet<String> fSystemPackageNames = null;
    private IVMInstall fVMBinding;
    private volatile boolean disposed;
    private volatile boolean restored;

    public ApiBaseline(String name) {
        super(null, 4, name);
        this.fEEStatus = Status.error((String)CoreMessages.ApiBaseline_0);
    }

    public ApiBaseline(String name, File eeDescription) throws CoreException {
        this(name, eeDescription, null);
    }

    public ApiBaseline(String name, File eeDescription, String location) throws CoreException {
        this(name);
        if (eeDescription != null) {
            this.fAutoResolve = false;
            ExecutionEnvironmentDescription ee = new ExecutionEnvironmentDescription(eeDescription);
            this.initialize(ee);
            this.fEEStatus = Status.OK_STATUS;
        }
        this.fLocation = location;
    }

    private void initialize(ExecutionEnvironmentDescription ee) throws CoreException {
        Properties properties = null;
        String environmentId = ee.getProperty("-Dee.class.library.level");
        if (ApiPlugin.isRunningInFramework()) {
            properties = ApiBaseline.getJavaProfileProperties(environmentId);
            if (properties == null) {
                IExecutionEnvironment ev = EnvironmentsManager.getDefault().getEnvironment(environmentId);
                properties = ev.getProfileProperties();
            }
        } else {
            properties = Util.getEEProfile(environmentId);
        }
        if (properties == null) {
            this.abort("Unknown execution environment: " + environmentId, null);
        } else {
            this.initialize(properties, ee);
        }
    }

    private static Properties getPropertiesFromURL(URL profileURL) {
        try {
            URL resolvedURL = FileLocator.resolve((URL)profileURL);
            URLConnection openConnection = resolvedURL.openConnection();
            openConnection.setUseCaches(false);
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = openConnection.getInputStream();){
                if (is != null) {
                    Properties profile = new Properties();
                    profile.load(is);
                    return profile;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        return null;
    }

    public static Properties getJavaProfileProperties(String ee) {
        Bundle osgiBundle = Platform.getBundle((String)"org.eclipse.osgi");
        if (osgiBundle == null) {
            return null;
        }
        URL profileURL = osgiBundle.getEntry(String.valueOf(ee.replace('/', '_')) + ".profile");
        if (profileURL != null) {
            return ApiBaseline.getPropertiesFromURL(profileURL);
        }
        return null;
    }

    private void initialize(Properties profile, ExecutionEnvironmentDescription description) throws CoreException {
        String value = profile.getProperty("org.osgi.framework.system.packages");
        if (value == null) {
            String environmentId = description.getProperty("-Dee.class.library.level");
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment environment = manager.getEnvironment(environmentId);
            value = TargetPlatformHelper.querySystemPackages((IExecutionEnvironment)environment);
        }
        String[] systemPackages = null;
        if (value != null) {
            systemPackages = value.split(",");
        }
        if (!(this instanceof WorkspaceBaseline)) {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            ((Dictionary)dictionary).put("org.osgi.framework.system.packages", value);
            value = profile.getProperty("org.osgi.framework.executionenvironment");
            if (value != null) {
                ((Dictionary)dictionary).put("org.osgi.framework.executionenvironment", value);
            }
            this.fExecutionEnvironment = profile.getProperty("osgi.java.profile.name");
            if (this.fExecutionEnvironment == null) {
                String id;
                this.fExecutionEnvironment = id = description.getProperty("-Dee.class.library.level");
                if (this.fExecutionEnvironment == null) {
                    this.abort("Profile file missing 'osgi.java.profile.name'", null);
                }
            }
            ((Dictionary)dictionary).put("osgi.os", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.arch", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.ws", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.nl", this.ANY_VALUE);
            this.getState().setPlatformProperties(dictionary);
        }
        if (!this.fSystemLibraryComponentList.isEmpty() && this.fComponentsById != null) {
            for (IApiComponent comp : this.fSystemLibraryComponentList) {
                this.fComponentsById.remove(comp.getSymbolicName());
            }
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
            this.fSystemPackageNames = null;
        }
        this.clearComponentsCache();
        SystemLibraryApiComponent fSystemLibraryComponent = new SystemLibraryApiComponent(this, description, systemPackages);
        this.addComponent(fSystemLibraryComponent);
        this.fSystemLibraryComponentList.add(fSystemLibraryComponent);
    }

    private void clearComponentsCache() {
        this.fComponentsProvidingPackageCache.clear();
    }

    protected void addComponent(IApiComponent component) {
        IApiComponent comp;
        if (this.isDisposed() || component == null) {
            return;
        }
        if (this.fComponentsById == null) {
            this.fComponentsById = new LinkedHashMap<String, IApiComponent>();
        }
        if (this.fAllComponentsById == null) {
            this.fAllComponentsById = new HashMap<String, Set<IApiComponent>>();
        }
        if ((comp = this.fComponentsById.get(component.getSymbolicName())) != null) {
            if (this.fAllComponentsById.containsKey(component.getSymbolicName())) {
                allComponents = this.fAllComponentsById.get(component.getSymbolicName());
                if (!allComponents.contains(component)) {
                    allComponents.add(component);
                }
            } else {
                allComponents = new TreeSet<IApiComponent>((comp1, comp2) -> {
                    if (comp2.getVersion().equals(comp1.getVersion())) {
                        if (comp2.getVersion().contains("JavaSE")) {
                            ApiPlugin.logInfoMessage("Multiple locations for the same Java = " + comp1.getLocation() + comp2.getLocation());
                        }
                        return 0;
                    }
                    return new Version(comp2.getVersion()).compareTo(new Version(comp1.getVersion()));
                });
                ((TreeSet)allComponents).add(comp);
                ((TreeSet)allComponents).add(component);
                this.fAllComponentsById.put(component.getSymbolicName(), allComponents);
            }
        }
        this.fComponentsById.put(component.getSymbolicName(), component);
        if (component instanceof ProjectComponent) {
            ProjectComponent projectApiComponent = (ProjectComponent)component;
            if (this.fComponentsByProjectNames == null) {
                this.fComponentsByProjectNames = new HashMap<String, IApiComponent>();
            }
            this.fComponentsByProjectNames.put(projectApiComponent.getJavaProject().getProject().getName(), component);
        }
    }

    @Override
    public void addApiComponents(IApiComponent[] components) throws CoreException {
        if (this.isDisposed()) {
            return;
        }
        HashSet<String> ees = new HashSet<String>();
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent apiComponent = iApiComponentArray[n2];
            BundleComponent component = (BundleComponent)apiComponent;
            if (!component.isSourceComponent()) {
                BundleDescription description = component.getBundleDescription();
                this.getState().addBundle(description);
                this.addComponent(component);
                ees.addAll(Arrays.asList(component.getExecutionEnvironments()));
            }
            ++n2;
        }
        this.resolveSystemLibrary(ees);
        this.getState().resolve();
    }

    protected void resolveSystemLibrary(HashSet<String> ees) {
        if (ApiPlugin.isRunningInFramework() && this.fAutoResolve) {
            IStatus error = null;
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            HashMap<IVMInstall, Set> vmToEEs = new HashMap<IVMInstall, Set>();
            for (String ee : ees) {
                Object compatibleVMs;
                IExecutionEnvironment environment = manager.getEnvironment(ee);
                if (environment == null) continue;
                Object object = compatibleVMs = environment.getCompatibleVMs();
                int n = ((Object)object).length;
                int n2 = 0;
                while (n2 < n) {
                    Object vm = object[n2];
                    vmToEEs.computeIfAbsent((IVMInstall)vm, m -> new HashSet()).add(ee);
                    ++n2;
                }
            }
            ArrayList allVMInstalls = new ArrayList(vmToEEs.keySet());
            String systemEE = null;
            if (!allVMInstalls.isEmpty()) {
                for (IVMInstall iVMInstall : allVMInstalls) {
                    IExecutionEnvironment[] environments;
                    IExecutionEnvironment[] iExecutionEnvironmentArray = environments = manager.getExecutionEnvironments();
                    int n = environments.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IExecutionEnvironment environment = iExecutionEnvironmentArray[n3];
                        if (environment.isStrictlyCompatible(iVMInstall)) {
                            systemEE = environment.getId();
                            break;
                        }
                        ++n3;
                    }
                    if (systemEE == null) {
                        systemEE = "JavaSE-" + JavaCore.latestSupportedJavaVersion();
                    }
                    if (systemEE.equals(this.getExecutionEnvironment()) && this.fVMBinding != null) continue;
                    try {
                        File file = Util.createEEFile(iVMInstall, systemEE);
                        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
                        this.fVMBinding = iVMInstall;
                        ExecutionEnvironmentDescription ee = new ExecutionEnvironmentDescription(file);
                        this.initialize(ee);
                        file.delete();
                    }
                    catch (IOException | CoreException e) {
                        error = Status.error((String)CoreMessages.ApiBaseline_2, (Throwable)e);
                    }
                }
            } else {
                error = Status.error((String)CoreMessages.ApiBaseline_6);
            }
            if (error == null) {
                HashSet<String> missing = new HashSet<String>(ees);
                HashSet covered = new HashSet();
                for (IVMInstall fit : allVMInstalls) {
                    covered.addAll((Collection)vmToEEs.get(fit));
                }
                missing.removeAll(covered);
                if (missing.isEmpty()) {
                    this.fEEStatus = Status.OK_STATUS;
                } else {
                    MultiStatus multi = new MultiStatus("org.eclipse.pde.api.tools", 0, CoreMessages.ApiBaseline_4, null);
                    for (String id : missing) {
                        multi.add(Status.warning((String)MessageFormat.format(CoreMessages.ApiBaseline_5, id)));
                    }
                    this.fEEStatus = multi;
                }
            } else {
                this.fEEStatus = error;
            }
        }
    }

    public boolean peekInfos() {
        return this.fComponentsById != null;
    }

    @Override
    public IApiComponent[] getApiComponents() {
        this.loadBaselineInfos();
        return this.getAlreadyLoadedApiComponents();
    }

    protected IApiComponent[] getAlreadyLoadedApiComponents() {
        Map<String, IApiComponent> componentsById = this.fComponentsById;
        if (this.disposed || componentsById == null) {
            return EMPTY_COMPONENTS;
        }
        Collection<IApiComponent> values = componentsById.values();
        return values.toArray(new IApiComponent[values.size()]);
    }

    @Override
    public IApiComponent[] resolvePackage(IApiComponent sourceComponent, String packageName) throws CoreException {
        if (this.disposed) {
            IStatus error = Status.error((String)("Trying to use disposed baseline " + this.getName()));
            throw new CoreException(error);
        }
        Map componentsForPackage = this.fComponentsProvidingPackageCache.computeIfAbsent(packageName, x -> new ConcurrentHashMap(8));
        IApiComponent[] cachedComponents = (IApiComponent[])componentsForPackage.get(sourceComponent);
        if (cachedComponents != null && cachedComponents.length > 0) {
            return cachedComponents;
        }
        if (sourceComponent != null) {
            ArrayList<IApiComponent> componentsList = new ArrayList<IApiComponent>();
            this.resolvePackage0(sourceComponent, packageName, componentsList);
            if (componentsList.size() != 0) {
                cachedComponents = new IApiComponent[componentsList.size()];
                componentsList.toArray(cachedComponents);
            }
        }
        if (this.isSystemPackage(packageName) && !this.fSystemLibraryComponentList.isEmpty()) {
            if (cachedComponents == null) {
                cachedComponents = this.fSystemLibraryComponentList.toArray(new IApiComponent[0]);
            } else {
                ArrayList<IApiComponent> list = new ArrayList<IApiComponent>(Arrays.asList(cachedComponents));
                list.addAll(this.fSystemLibraryComponentList);
                cachedComponents = list.toArray(new IApiComponent[0]);
            }
        }
        if (cachedComponents == null) {
            cachedComponents = EMPTY_COMPONENTS;
        }
        if (cachedComponents.length == 0) {
            return EMPTY_COMPONENTS;
        }
        componentsForPackage.put(sourceComponent, cachedComponents);
        return cachedComponents;
    }

    private void resolvePackage0(IApiComponent component, String packageName, List<IApiComponent> componentsList) throws CoreException {
        BundleDescription bundle;
        if (component instanceof BundleComponent && (bundle = ((BundleComponent)component).getBundleDescription()) != null) {
            String[] packageNames;
            int index;
            ExportPackageDescription[] visiblePackages;
            StateHelper helper = this.getState().getStateHelper();
            ExportPackageDescription[] exportPackageDescriptionArray = visiblePackages = helper.getVisiblePackages(bundle);
            int n = visiblePackages.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundleDescription;
                IApiComponent exporter;
                ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
                String pkgName = pkg.getName();
                if (pkgName.equals(".")) {
                    pkgName = "";
                }
                if (packageName.equals(pkgName) && (exporter = this.getApiComponent((bundleDescription = pkg.getExporter()).getSymbolicName())) != null) {
                    componentsList.add(exporter);
                }
                ++n2;
            }
            if (component.isFragment()) {
                BundleDescription[] hosts;
                HostSpecification host = bundle.getHost();
                BundleDescription[] bundleDescriptionArray = hosts = host.getHosts();
                int n3 = hosts.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleDescription currentHost = bundleDescriptionArray[n4];
                    IApiComponent apiComponent = component.getBaseline().getApiComponent(currentHost.getName());
                    if (apiComponent != null) {
                        this.resolvePackage0(apiComponent, packageName, componentsList);
                    }
                    ++n4;
                }
            }
            if ((index = Arrays.binarySearch(packageNames = component.getPackageNames(), packageName, null)) >= 0) {
                componentsList.add(component);
            }
        }
    }

    public IApiComponent[] getVisibleDependentComponents(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = this.getBundleDescriptions(components);
        BundleDescription[] descs = this.getState().getStateHelper().getDependentBundles(bundles.toArray(new BundleDescription[bundles.size()]));
        HashSet<BundleDescription> visible = new HashSet<BundleDescription>();
        ExportPackageDescription[] packages = null;
        BundleDescription[] bundleDescriptionArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription desc = bundleDescriptionArray[n2];
            ExportPackageDescription[] exportPackageDescriptionArray = packages = this.getState().getStateHelper().getVisiblePackages(desc);
            int n3 = packages.length;
            int n4 = 0;
            while (n4 < n3) {
                ExportPackageDescription package1 = exportPackageDescriptionArray[n4];
                if (bundles.contains(package1.getSupplier())) {
                    visible.add(desc);
                }
                ++n4;
            }
            ++n2;
        }
        return this.getApiComponents(visible);
    }

    private boolean isSystemPackage(String packageName) {
        if (packageName.startsWith("java.")) {
            return true;
        }
        if (this.fSystemPackageNames == null) {
            ExportPackageDescription[] systemPackages = this.getState().getSystemPackages();
            this.fSystemPackageNames = new HashSet(systemPackages.length);
            ExportPackageDescription[] exportPackageDescriptionArray = systemPackages;
            int n = systemPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription systemPackage = exportPackageDescriptionArray[n2];
                this.fSystemPackageNames.add(systemPackage.getName());
                ++n2;
            }
        }
        return this.fSystemPackageNames.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        if (this.disposed) {
            return this.fState;
        }
        if (this.fState == null) {
            ApiBaseline apiBaseline = this;
            synchronized (apiBaseline) {
                this.fState = StateObjectFactory.defaultFactory.createState(true);
            }
        }
        return this.fState;
    }

    @Override
    public IApiComponent getApiComponent(String id) {
        this.loadBaselineInfos();
        Map<String, IApiComponent> componentsById = this.fComponentsById;
        if (this.disposed || componentsById == null) {
            return null;
        }
        return componentsById.get(id);
    }

    @Override
    public Set<IApiComponent> getAllApiComponents(String id) {
        this.loadBaselineInfos();
        Map<String, Set<IApiComponent>> componentsById = this.fAllComponentsById;
        if (this.disposed || componentsById == null) {
            return Collections.emptySet();
        }
        Set<IApiComponent> set = componentsById.get(id);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    @Override
    public String getExecutionEnvironment() {
        return this.fExecutionEnvironment;
    }

    private void loadBaselineInfos() {
        if (this.disposed || this.restored) {
            return;
        }
        ApiBaselineManager manager = ApiBaselineManager.getManager();
        if (this.fComponentsById != null && manager.isBaselineLoaded(this)) {
            return;
        }
        if (this.disposed || this.restored) {
            return;
        }
        try {
            manager.loadBaselineInfos(this);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFrom(InputStream stream) throws CoreException {
        if (this.disposed || this.restored) {
            return;
        }
        IApiComponent[] components = ApiBaselineManager.getManager().readBaselineComponents(this, stream);
        if (components == null) {
            this.restored = true;
            return;
        }
        ApiBaseline apiBaseline = this;
        synchronized (apiBaseline) {
            if (this.disposed || this.restored) {
                IApiComponent[] iApiComponentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiComponent component = iApiComponentArray[n2];
                    component.dispose();
                    ++n2;
                }
                return;
            }
            this.addApiComponents(components);
            this.restored = true;
        }
    }

    public ResolverError[] getErrors() {
        BundleDescription[] bundles;
        ArrayList<ResolverError> errs = null;
        BundleDescription[] bundleDescriptionArray = bundles = this.getState().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverError[] errors;
            BundleDescription bundle = bundleDescriptionArray[n2];
            ResolverError[] resolverErrorArray = errors = this.getState().getResolverErrors(bundle);
            int n3 = errors.length;
            int n4 = 0;
            while (n4 < n3) {
                ResolverError error = resolverErrorArray[n4];
                if (errs == null) {
                    errs = new ArrayList<ResolverError>();
                }
                errs.add(error);
                ++n4;
            }
            ++n2;
        }
        if (errs != null) {
            return errs.toArray(new ResolverError[errs.size()]);
        }
        return null;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiBaseline) {
            IApiBaseline baseline = (IApiBaseline)obj;
            return this.getName().equals(baseline.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void dispose() {
        if (this.fState == null) {
            return;
        }
        this.doDispose();
        this.fState = null;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        IApiComponent[] components;
        if (this.disposed) {
            return;
        }
        ApiBaseline apiBaseline = this;
        synchronized (apiBaseline) {
            components = this.getAlreadyLoadedApiComponents();
            this.disposed = true;
        }
        this.clearCachedElements();
        if (ApiPlugin.isRunningInFramework()) {
            JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
        }
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            component2.dispose();
            ++n2;
        }
        this.clearComponentsCache();
        if (this.fComponentsById != null) {
            this.fComponentsById.clear();
            this.fComponentsById = null;
        }
        if (this.fAllComponentsById != null) {
            this.fAllComponentsById.clear();
            this.fAllComponentsById = null;
        }
        if (this.fComponentsByProjectNames != null) {
            this.fComponentsByProjectNames.clear();
            this.fComponentsByProjectNames = null;
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
        }
        if (!this.fSystemLibraryComponentList.isEmpty()) {
            for (IApiComponent iApiComponent : this.fSystemLibraryComponentList) {
                iApiComponent.dispose();
            }
            this.fSystemLibraryComponentList = new ArrayList();
        }
    }

    @Override
    public void close() throws CoreException {
        IApiComponent[] components;
        this.clearCachedElements();
        IApiComponent[] iApiComponentArray = components = this.getApiComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            component2.close();
            ++n2;
        }
    }

    void clearCachedElements() {
        ApiModelCache.getCache().removeElementInfo(this);
    }

    private IApiComponent[] getApiComponents(Collection<BundleDescription> bundles) {
        ArrayList<IApiComponent> dependents = new ArrayList<IApiComponent>(bundles.size());
        for (BundleDescription bundle : bundles) {
            IApiComponent component = this.getApiComponent(bundle.getSymbolicName());
            if (component == null) continue;
            dependents.add(component);
        }
        return dependents.toArray(new IApiComponent[dependents.size()]);
    }

    private ArrayList<BundleDescription> getBundleDescriptions(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>(components.length);
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component = iApiComponentArray[n2];
            if (component instanceof BundleComponent) {
                bundles.add(((BundleComponent)component).getBundleDescription());
            }
            ++n2;
        }
        return bundles;
    }

    @Override
    public IApiComponent[] getPrerequisiteComponents(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = this.getBundleDescriptions(components);
        return this.getApiComponents(BuildDependencyCollector.collectBuildRelevantDependencies(bundles));
    }

    public void clearPackage(String packageName) {
        this.fComponentsProvidingPackageCache.remove(packageName);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IStatus getExecutionEnvironmentStatus() {
        return this.fEEStatus;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    public void vmAdded(IVMInstall vm) {
        if (!(vm instanceof VMStandin)) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property;
        if (!(event.getSource() instanceof VMStandin) && (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property = event.getProperty()) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property))) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    private void rebindVM() throws CoreException {
        this.fVMBinding = null;
        IApiComponent[] components = this.getApiComponents();
        HashSet<String> ees = new HashSet<String>();
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            ees.addAll(Arrays.asList(component2.getExecutionEnvironments()));
            ++n2;
        }
        this.resolveSystemLibrary(ees);
    }

    public void vmRemoved(IVMInstall vm) {
        if (vm.equals(this.fVMBinding)) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    @Override
    public String getLocation() {
        return this.fLocation;
    }

    @Override
    public void setLocation(String location) {
        this.fLocation = location;
    }

    @Override
    public IApiComponent getApiComponent(IProject project) {
        this.loadBaselineInfos();
        Map<String, IApiComponent> componentsByProjectNames = this.fComponentsByProjectNames;
        if (this.disposed || componentsByProjectNames == null) {
            return null;
        }
        return componentsByProjectNames.get(project.getName());
    }
}

