/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTBinaryExprNode;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.ASTNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.parser.IExecutableConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.parser.IObsoleteActionStmt;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class ChangeToVectorNotationRefactoring
extends FortranEditorRefactoring {
    private ASTProperLoopConstructNode DoLoopNode = null;

    @Override
    public String getName() {
        return "Change to Vector Notation";
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.ensureDoLoopHasBeenSelected();
        this.checkIfCanBeChanged();
    }

    private void checkIfCanBeChanged() throws VPGRefactoring.PreconditionFailure {
        Token index = this.DoLoopNode.getIndexVariable();
        DependencyFinderVisitor dependencyFinder = new DependencyFinderVisitor(index.getText());
        VectorNotationVisitor changer = new VectorNotationVisitor(index.getText());
        this.DoLoopNode.accept(dependencyFinder);
        this.DoLoopNode.getBody().accept(changer);
        if (!changer.canBeChanged() || dependencyFinder.getHasDependencies()) {
            if (!changer.canBeChanged()) {
                this.fail(Messages.bind((String)Messages.ChangeToVectorNotation_CanNotBeChanged, (Object)changer.failMessage));
            } else {
                this.fail(Messages.ChangeToVectorNotation_CanNotBeChangedToVectorNotation);
            }
        }
    }

    private void ensureDoLoopHasBeenSelected() throws VPGRefactoring.PreconditionFailure {
        ASTNode oldNode = ChangeToVectorNotationRefactoring.getNode(this.astOfFileInEditor, this.selectedRegionInEditor, ASTProperLoopConstructNode.class);
        if (oldNode == null) {
            this.fail(Messages.ChangeToVectorNotation_PleaseSelectDoLoopNode);
        } else if (!this.isOldStyleDoLoop((ASTProperLoopConstructNode)oldNode)) {
            this.DoLoopNode = (ASTProperLoopConstructNode)oldNode;
        } else {
            this.fail(Messages.ChangeToVectorNotation_PleaseSelectNewStyleDoLoopNode);
        }
    }

    private boolean isOldStyleDoLoop(ASTProperLoopConstructNode node) {
        return node.getEndDoStmt() == null && node.getLoopHeader().getLblRef() != null;
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IASTNode newNode = this.getNewCode(this.DoLoopNode);
        this.DoLoopNode.replaceWith(String.valueOf(newNode.toString().trim()) + "\n");
        Reindenter.reindent(this.DoLoopNode, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private IASTNode getNewCode(ASTProperLoopConstructNode node) {
        IExpr lowerBound = this.DoLoopNode.getLowerBoundIExpr();
        IExpr upperBound = this.DoLoopNode.getUpperBoundIExpr();
        final String newIndex = String.valueOf(lowerBound.toString()) + ":" + upperBound.toString();
        final String indexVariable = this.DoLoopNode.getIndexVariable().getText();
        IASTListNode newBody = (IASTListNode)node.getBody().clone();
        newBody.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT && token.getText().equals(indexVariable)) {
                    String s2 = token.getText();
                    s2 = newIndex;
                    token.replaceWith(s2);
                }
            }
        });
        return newBody;
    }

    public class DependencyFinderVisitor
    extends ASTVisitorWithLoops {
        private boolean hasDependencies = false;
        private String indexVarName;

        public DependencyFinderVisitor(String indexVarName) {
            this.indexVarName = indexVarName;
        }

        public boolean getHasDependencies() {
            return this.hasDependencies;
        }

        @Override
        public void visitASTBinaryExprNode(ASTBinaryExprNode node) {
            IExpr lhsExpr = node.getLhsExpr();
            IExpr rhsExpr = node.getRhsExpr();
            this.checkExpr(lhsExpr);
            this.checkExpr(rhsExpr);
            this.traverseChildren(node);
        }

        private void checkExpr(IExpr Expr) {
            ASTNameNode nameNode;
            if (this.IsVariable(Expr) && (nameNode = ((ASTVarOrFnRefNode)Expr).getName()) != null && this.indexVarName.equals(nameNode.getName().getText())) {
                this.hasDependencies = true;
            }
        }

        private boolean IsVariable(IExpr Expr) {
            return Expr instanceof ASTVarOrFnRefNode;
        }
    }

    public class VectorNotationVisitor
    extends ASTVisitorWithLoops {
        private boolean CanChangeVectorNotation = true;
        private String indexVarName;
        private String failMessage = "";

        public VectorNotationVisitor(String indexVarName) {
            this.indexVarName = indexVarName;
        }

        public boolean canBeChanged() {
            return this.CanChangeVectorNotation;
        }

        public String getFailMessage() {
            return this.failMessage;
        }

        @Override
        public void visitIExecutionPartConstruct(IExecutionPartConstruct node) {
            if (!(node instanceof ASTAssignmentStmtNode)) {
                this.CanChangeVectorNotation = false;
            } else {
                this.CheckAsignmentNode((ASTAssignmentStmtNode)node);
            }
        }

        private void CheckAsignmentNode(ASTAssignmentStmtNode node) {
            Token lhsVariable = node.getLhsVariable().getName();
            IExpr rhs = node.getRhs();
            if (!this.leftHandCanBeChanged(lhsVariable)) {
                this.CanChangeVectorNotation = false;
            }
            this.CheckRightHandExpr(rhs);
        }

        private void CheckRightHandExpr(IExpr rhs) {
            Token varName;
            ASTNameNode nameNode;
            if (rhs instanceof ASTBinaryExprNode) {
                this.CheckRightHandExpr(((ASTBinaryExprNode)rhs).getLhsExpr());
                this.CheckRightHandExpr(((ASTBinaryExprNode)rhs).getRhsExpr());
            }
            if (rhs instanceof ASTVarOrFnRefNode && (nameNode = ((ASTVarOrFnRefNode)rhs).getName()) != null && (varName = nameNode.getName()) != null && varName.getText().toString().equals(this.indexVarName)) {
                this.CanChangeVectorNotation = false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean leftHandCanBeChanged(Token lhsVariable) {
            if (!lhsVariable.isIdentifier()) return false;
            List<Definition> definitions = lhsVariable.resolveBinding();
            if (!definitions.isEmpty() && definitions.size() == 1) {
                Definition symbol = definitions.get(0);
                if (symbol.isArray()) return true;
                this.failMessage = "Variable " + lhsVariable.getText() + " must be an explicitly defined array";
                return false;
            }
            this.failMessage = "Variable " + lhsVariable.getText() + " must be an explicitly defined array";
            return false;
        }

        @Override
        public void visitIExecutableConstruct(IExecutableConstruct node) {
            this.visitIExecutionPartConstruct(node);
        }

        @Override
        public void visitIActionStmt(IActionStmt node) {
            this.visitIExecutionPartConstruct(node);
        }

        @Override
        public void visitIObsoleteActionStmt(IObsoleteActionStmt node) {
            this.visitIExecutionPartConstruct(node);
        }
    }
}

