/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAccessSpecNode;
import org.eclipse.photran.internal.core.parser.ASTAccessStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecSeqNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTGenericNameNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicStmtNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTObjectNameNode;
import org.eclipse.photran.internal.core.parser.ASTSeparatedListNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class MakePrivateEntityPublicRefactoring
extends FortranEditorRefactoring {
    private int numPrivateEnt = 0;
    private String identName = null;
    private ASTAccessSpecNode accessNodeSpec = null;
    private ASTAccessStmtNode accessNode = null;
    private ASTGenericNameNode identifierNode = null;
    private String selectedVarType;
    private String varSpecAttrs = "";
    private ASTTypeDeclarationStmtNode declarationStmtNode = null;
    private ASTEntityDeclNode entDeclNode = null;
    private ASTObjectNameNode identNameNode = null;
    private ASTSubroutineSubprogramNode subroutineNode = null;
    private ASTFunctionSubprogramNode functionNode = null;
    private ASTAccessStmtNode lonePrivateNode = null;
    private boolean entireProgramPriv = false;

    @Override
    public String getName() {
        return Messages.MakePrivateEntityPublicRefactoring_Name;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        Token token = this.findEnclosingToken();
        this.checkForUnsupportedType(token);
        this.identName = this.selectedRegionInEditor.getText();
        if (this.identName.equals("")) {
            this.fail(Messages.MakePrivateEntityPublicRefactoring_SelectPrivateEntityName);
        }
        this.accessNode = token.findNearestAncestor(ASTAccessStmtNode.class);
        if (this.accessNode != null) {
            this.accessNodeSpec = this.accessNode.getAccessSpec();
            this.identifierNode = token.findNearestAncestor(ASTGenericNameNode.class);
            this.numPrivateEnt = this.accessNode.getAccessIdList().size();
        } else {
            this.readDeclarationStmtNode(token);
        }
        if (this.declarationStmtNode == null && this.accessNode == null) {
            this.checkForSubroutineStmtNode(token);
        }
        if (this.subroutineNode == null && this.accessNode == null) {
            this.checkForFunctionStmtNode(token);
        }
        if (this.accessNodeSpec == null) {
            this.fail(Messages.MakePrivateEntityPublicRefactoring_NoPrivateEntitySelected);
        }
        if (this.accessNodeSpec.isPublic()) {
            this.fail(Messages.MakePrivateEntityPublicRefactoring_PublicEntitySelectedSelectPrivate);
        }
    }

    private Token findEnclosingToken() throws VPGRefactoring.PreconditionFailure {
        Token selectedToken = MakePrivateEntityPublicRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedToken == null) {
            this.fail(Messages.MakePrivateEntityPublicRefactoring_HighlightPrivateEntityName);
        }
        return selectedToken;
    }

    private void checkForUnsupportedType(Token token) throws VPGRefactoring.PreconditionFailure {
        ASTIntrinsicStmtNode intrinsic = token.findNearestAncestor(ASTIntrinsicStmtNode.class);
        ASTExternalStmtNode external = token.findNearestAncestor(ASTExternalStmtNode.class);
        ASTInterfaceBlockNode interfaceNode = token.findNearestAncestor(ASTInterfaceBlockNode.class);
        if (intrinsic != null) {
            this.fail(Messages.MakePrivateEntityPublicRefactoring_DoesNotSupportIntrinsicEntities);
        } else if (external != null) {
            this.fail(Messages.MakePrivateEntityPublicRefactoring_DoesNotSupportExternalEntities);
        } else if (interfaceNode != null) {
            this.fail(Messages.MakePrivateEntityPublicRefactoring_DoesNotSupportInterfaceDeclarations);
        }
    }

    private void readDeclarationStmtNode(Token token) throws VPGRefactoring.PreconditionFailure {
        this.selectedVarType = ((PhotranVPG)this.vpg).getDefinitionFor(token.getTokenRef()).getType().toString();
        this.declarationStmtNode = token.findNearestAncestor(ASTTypeDeclarationStmtNode.class);
        this.entDeclNode = token.findNearestAncestor(ASTEntityDeclNode.class);
        if (this.declarationStmtNode == null || this.entDeclNode == null) {
            return;
        }
        if (this.declarationStmtNode.getAttrSpecSeq() != null) {
            for (ASTAttrSpecSeqNode attrNode : this.declarationStmtNode.getAttrSpecSeq()) {
                ASTAttrSpecNode specNode = attrNode.getAttrSpec();
                if (!specNode.toString().trim().equals("private")) {
                    this.varSpecAttrs = String.valueOf(this.varSpecAttrs) + ",";
                    this.varSpecAttrs = String.valueOf(this.varSpecAttrs) + specNode.toString();
                }
                if (specNode.getAccessSpec() == null) continue;
                this.accessNodeSpec = specNode.getAccessSpec();
            }
        }
        if (this.accessNodeSpec == null) {
            this.checkIfEntireProgramPriv(token);
        }
        this.identNameNode = token.findNearestAncestor(ASTObjectNameNode.class);
        if (this.accessNodeSpec != null || this.entireProgramPriv) {
            this.numPrivateEnt = this.declarationStmtNode.getEntityDeclList().size();
        }
    }

    private void checkForSubroutineStmtNode(Token token) throws VPGRefactoring.PreconditionFailure {
        this.subroutineNode = token.findNearestAncestor(ASTSubroutineSubprogramNode.class);
        if (this.subroutineNode != null) {
            this.checkIfEntireProgramPriv(token);
            this.numPrivateEnt = 1;
        }
    }

    private void checkForFunctionStmtNode(Token token) {
        this.functionNode = token.findNearestAncestor(ASTFunctionSubprogramNode.class);
        if (this.functionNode != null) {
            this.checkIfEntireProgramPriv(token);
            this.numPrivateEnt = 1;
        }
    }

    private void checkIfEntireProgramPriv(Token token) {
        ASTListNode progBody = null;
        if (this.declarationStmtNode != null) {
            progBody = (ASTListNode)this.declarationStmtNode.getParent();
        } else if (this.subroutineNode != null) {
            progBody = token.findNearestAncestor(ASTMainProgramNode.class) != null ? (ASTListNode)((ASTMainProgramNode)this.subroutineNode.getParent().getParent()).getBody() : (ASTListNode)this.subroutineNode.getParent();
        } else if (this.functionNode != null) {
            progBody = token.findNearestAncestor(ASTMainProgramNode.class) != null ? (ASTListNode)((ASTMainProgramNode)this.functionNode.getParent().getParent()).getBody() : (ASTListNode)this.functionNode.getParent();
        }
        int i = 0;
        while (i < progBody.size()) {
            ASTAccessStmtNode node;
            if (progBody.get(i) instanceof ASTAccessStmtNode && (node = (ASTAccessStmtNode)progBody.get(i)).getAccessIdList() == null && node.getAccessSpec().isPrivate()) {
                this.accessNodeSpec = node.getAccessSpec();
                this.lonePrivateNode = node;
                this.entireProgramPriv = true;
            }
            ++i;
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor);
        if (ast == null) {
            return;
        }
        if (this.numPrivateEnt == 1) {
            this.changePrivateToPublic(ast);
        } else if (this.numPrivateEnt > 1) {
            this.createPublicNode(ast);
            this.removeIdentifierFromPrivateList();
        }
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void changePrivateToPublic(IFortranAST ast) {
        if (this.entireProgramPriv) {
            this.handleDeclarationSubroutineOrFunction(ast);
        } else {
            Token newToken = new Token(Terminal.T_PUBLIC, "public");
            this.accessNodeSpec.setIsPrivate(null);
            this.accessNodeSpec.setIsPublic(newToken);
            if (this.accessNode != null) {
                Reindenter.reindent(this.accessNode, ast);
            } else {
                Reindenter.reindent(this.declarationStmtNode, ast);
            }
        }
    }

    private void handleDeclarationSubroutineOrFunction(IFortranAST ast) {
        if (this.declarationStmtNode != null) {
            ASTTypeDeclarationStmtNode newStmtNode = (ASTTypeDeclarationStmtNode)MakePrivateEntityPublicRefactoring.parseLiteralStatement(String.valueOf(this.selectedVarType) + ", public" + this.varSpecAttrs + " :: " + this.identNameNode.getObjectName().getText() + System.getProperty("line.separator"));
            ASTListNode body = (ASTListNode)this.declarationStmtNode.getParent();
            body.replaceChild(this.declarationStmtNode, newStmtNode);
            Reindenter.reindent(newStmtNode, ast);
        } else if (this.subroutineNode != null || this.functionNode != null) {
            ASTAccessStmtNode newStmtNode = (ASTAccessStmtNode)MakePrivateEntityPublicRefactoring.parseLiteralStatement("public " + this.identName + System.getProperty("line.separator"));
            ASTListNode body = (ASTListNode)this.lonePrivateNode.getParent();
            body.insertAfter(this.lonePrivateNode, newStmtNode);
            Reindenter.reindent(newStmtNode, ast);
        }
    }

    private void createPublicNode(IFortranAST ast) {
        if (this.accessNode != null) {
            ASTAccessStmtNode newStmtNode = (ASTAccessStmtNode)MakePrivateEntityPublicRefactoring.parseLiteralStatement("public " + this.identifierNode.getGenericName().getText() + System.getProperty("line.separator"));
            ASTListNode body = (ASTListNode)this.accessNode.getParent();
            body.insertAfter(this.accessNode, newStmtNode);
            Reindenter.reindent(newStmtNode, ast);
        } else {
            ASTTypeDeclarationStmtNode newStmtNode = (ASTTypeDeclarationStmtNode)MakePrivateEntityPublicRefactoring.parseLiteralStatement(String.valueOf(this.selectedVarType) + ", public" + this.varSpecAttrs + " :: " + this.identNameNode.getObjectName().getText() + System.getProperty("line.separator"));
            ASTListNode body = (ASTListNode)this.declarationStmtNode.getParent();
            body.insertAfter(this.declarationStmtNode, newStmtNode);
            Reindenter.reindent(newStmtNode, ast);
        }
    }

    private void removeIdentifierFromPrivateList() {
        if (this.accessNode != null) {
            ASTSeparatedListNode list = (ASTSeparatedListNode)this.accessNode.getAccessIdList();
            list.remove(this.identifierNode);
        } else {
            ASTSeparatedListNode list = (ASTSeparatedListNode)this.declarationStmtNode.getEntityDeclList();
            list.remove(this.entDeclNode);
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }
}

