/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.parser.ASTComputedGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLblRefListNode;
import org.eclipse.photran.internal.core.parser.ASTNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class RemoveComputedGoToRefactoring
extends FortranEditorRefactoring {
    private ASTComputedGotoStmtNode computedGoto = null;

    @Override
    public String getName() {
        return Messages.RemoveComputedGoToRefactoring_Name;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        ASTNode oldNode = RemoveComputedGoToRefactoring.getNode(this.astOfFileInEditor, this.selectedRegionInEditor, ASTComputedGotoStmtNode.class);
        if (oldNode == null) {
            this.fail(Messages.RemoveComputedGoToRefactoring_PleaseSelectComputedGotoStmt);
        } else {
            this.computedGoto = (ASTComputedGotoStmtNode)oldNode;
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IASTNode newNode = this.makeSelectStmt();
        this.computedGoto.replaceWith(newNode);
        this.copyCommentsFromOldNode(newNode);
        Reindenter.reindent(newNode, this.astOfFileInEditor);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private IASTNode makeSelectStmt() {
        this.removeLeadingSpacesFrom(this.computedGoto.getExpr());
        StringBuilder stmt = new StringBuilder(256);
        stmt.append("select case (");
        stmt.append(this.computedGoto.getExpr());
        stmt.append(")\n");
        int i = 1;
        for (ASTLblRefListNode refListNode : this.computedGoto.getLblRefList()) {
            stmt.append("case (");
            stmt.append(i);
            stmt.append(")\n        go to ");
            stmt.append(refListNode.getLabel().getText());
            stmt.append("\n");
            ++i;
        }
        stmt.append("end select");
        return RemoveComputedGoToRefactoring.parseLiteralStatementNoFail(stmt.toString());
    }

    private void removeLeadingSpacesFrom(IExpr expr) {
        expr.findFirstToken().setWhiteBefore("");
    }

    private void copyCommentsFromOldNode(IASTNode newNode) {
        newNode.findFirstToken().setWhiteBefore(this.computedGoto.findFirstToken().getWhiteBefore());
    }
}

