/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.parser.ASTContinueStmtNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTLblRefNode;
import org.eclipse.photran.internal.core.parser.ASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class RemoveUnreferencedLabelsRefactoring
extends FortranEditorRefactoring {
    private Map<String, Integer> labelMap;

    @Override
    public String getName() {
        return Messages.RemoveUnreferencedLabelsRefactoring_Name;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.labelMap = new HashMap<String, Integer>();
        this.ensureProjectHasRefactoringEnabled(status);
        this.collectAllLabels(this.astOfFileInEditor.getRoot());
        this.collectAllReferences(this.astOfFileInEditor.getRoot());
        if (this.labelMap.size() == 0) {
            this.fail(Messages.RemoveUnreferencedLabelsRefactoring_ThereMustBeAtLeastOneLabeledStatement);
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ASTExecutableProgramNode scope = this.astOfFileInEditor.getRoot();
        ((ASTNode)scope).accept(new ASTVisitorWithLoops(){

            @Override
            public void visitIActionStmt(IActionStmt node) {
                if (node.getLabel() != null) {
                    Integer refCount;
                    String key = node.getLabel().getText();
                    if (RemoveUnreferencedLabelsRefactoring.this.labelMap.containsKey(key) && (refCount = (Integer)RemoveUnreferencedLabelsRefactoring.this.labelMap.get(key)) == 0) {
                        node.setLabel(null);
                        if (node instanceof ASTContinueStmtNode) {
                            node.removeFromTree();
                        }
                        Reindenter.reindent(node, RemoveUnreferencedLabelsRefactoring.this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
                    }
                }
            }
        });
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void collectAllLabels(ScopingNode scope) {
        scope.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitIActionStmt(IActionStmt node) {
                if (node.getLabel() != null) {
                    String key = node.getLabel().getText();
                    if (!RemoveUnreferencedLabelsRefactoring.this.labelMap.containsKey(key)) {
                        RemoveUnreferencedLabelsRefactoring.this.labelMap.put(key, new Integer(0));
                    }
                }
                this.traverseChildren(node);
            }
        });
    }

    private void collectAllReferences(ScopingNode scope) {
        scope.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitASTLblRefNode(ASTLblRefNode node) {
                if (node.getLabel() != null) {
                    String key = node.getLabel().getText();
                    if (RemoveUnreferencedLabelsRefactoring.this.labelMap.containsKey(key)) {
                        RemoveUnreferencedLabelsRefactoring.this.labelMap.put(key, (Integer)RemoveUnreferencedLabelsRefactoring.this.labelMap.get(key) + 1);
                    }
                }
                this.traverseChildren(node);
            }
        });
    }
}

