/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda.util;

import java.util.Vector;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.internal.useractions.ui.uda.util.UDAFileTypesForName;

public class UDAResolvedTypes {
    protected Vector previousTypes = null;

    protected void addTypesToVector(Vector v, Object[] objElems) {
        int i = 0;
        while (i < objElems.length) {
            SystemUDTypeElement typeElem = (SystemUDTypeElement)objElems[i];
            String name = typeElem.toString();
            this.resolveType(name, v, objElems);
            ++i;
        }
    }

    protected String resolveTypes(String types, Vector v, Object[] objElems) {
        int i = types.indexOf("<");
        if (i < 0) {
            return types;
        }
        int j = types.indexOf(">");
        if (i >= j) {
            return types;
        }
        String type = types.substring(i + 1, j);
        String resolvedType = this.resolveType(type, v, objElems);
        return String.valueOf(types.substring(0, i)) + " " + resolvedType + " " + this.resolveTypes(types.substring(j + 1), v, objElems);
    }

    protected String resolveType(String type, Vector v, Object[] objElems) {
        if (this.previousTypes.contains(type)) {
            return "";
        }
        String resolvedTypes = this.resolveType(type, v);
        if (resolvedTypes != null) {
            return resolvedTypes;
        }
        int i = 0;
        while (i < objElems.length) {
            SystemUDTypeElement typeElem = (SystemUDTypeElement)objElems[i];
            if (type.equals(typeElem.toString())) {
                this.previousTypes.addElement(type);
                resolvedTypes = this.resolveTypes(typeElem.getTypes(), v, objElems);
                this.previousTypes.remove(type);
                v.addElement(new UDAFileTypesForName(type, resolvedTypes));
                return resolvedTypes;
            }
            ++i;
        }
        return "";
    }

    protected String resolveType(String type, Vector v) {
        int i = 0;
        while (i < v.size()) {
            UDAFileTypesForName typesForName = (UDAFileTypesForName)v.elementAt(i);
            if (type.equals(typesForName.getName())) {
                return typesForName.getTypes();
            }
            ++i;
        }
        return null;
    }

    public String getFileTypesForTypeName(String name, int type, SystemUDTypeManager typeMgr) {
        return null;
    }
}

