/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumSourceDirector;
import org.eclipse.wst.jsdt.chromium.debug.core.ScriptNameManipulator;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointInTargetMap;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumBreakpointAdapter;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumExceptionBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceRef;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class BreakpointSynchronizer {
    private final JavascriptVm javascriptVm;
    private final ChromiumSourceDirector sourceDirector;
    private final BreakpointHelper breakpointHelper;
    private final String debugModelId;
    private static final RelayOk UNCODITIONALLY_RELAY_TO_REST_OF_METHOD_OK = new RelayOk(){};
    private final PropertyHandler<ChromiumLineBreakpoint> uiBreakpointHandler = new PropertyHandler<ChromiumLineBreakpoint>(){

        @Override
        long getLineNumber(ChromiumLineBreakpoint chromiumLineBreakpoint) {
            try {
                return chromiumLineBreakpoint.getLineNumber() - 1;
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        VmResourceRef getVmResourceRef(ChromiumLineBreakpoint chromiumLineBreakpoint) {
            IMarker marker = chromiumLineBreakpoint.getMarker();
            if (marker == null) {
                return null;
            }
            IResource resource = marker.getResource();
            if (!(resource instanceof IFile)) {
                return null;
            }
            IFile file = (IFile)resource;
            try {
                return BreakpointSynchronizer.this.sourceDirector.findVmResourceRef(file);
            }
            catch (CoreException e) {
                throw new RuntimeException("Failed to read script name from breakpoint", e);
            }
        }
    };
    private static final PropertyHandler<Breakpoint> sdkBreakpointHandler = new PropertyHandler<Breakpoint>(){
        private final Breakpoint.Target.Visitor<VmResourceRef> resourceRefVisitor = new BreakpointTypeExtension.ScriptRegExpSupport.Visitor<VmResourceRef>(){

            public VmResourceRef visitScriptName(String scriptName) {
                return VmResourceRef.forVmResourceId(new VmResourceId(scriptName, null));
            }

            public VmResourceRef visitScriptId(Object scriptId) {
                return VmResourceRef.forVmResourceId(new VmResourceId(null, scriptId));
            }

            public VmResourceRef visitRegExp(String regExp) {
                if (regExp == null) {
                    return null;
                }
                ScriptNameManipulator.ScriptNamePattern pattern = new ScriptNameManipulator.ScriptNamePattern(regExp);
                return VmResourceRef.forRegExpBased(pattern);
            }

            public VmResourceRef visitUnknown(Breakpoint.Target target) {
                return null;
            }
        };

        @Override
        long getLineNumber(Breakpoint breakpoint) {
            return breakpoint.getLineNumber();
        }

        @Override
        VmResourceRef getVmResourceRef(Breakpoint breakpoint) {
            return (VmResourceRef)breakpoint.getTarget().accept(this.resourceRefVisitor);
        }
    };

    public BreakpointSynchronizer(JavascriptVm javascriptVm, ChromiumSourceDirector sourceDirector, BreakpointHelper breakpointHelper, String debugModelId) {
        this.javascriptVm = javascriptVm;
        this.sourceDirector = sourceDirector;
        this.breakpointHelper = breakpointHelper;
        this.debugModelId = debugModelId;
    }

    public void syncBreakpoints(Direction direction, Callback callback) {
        ReportBuilder reportBuilder = new ReportBuilder(direction);
        StatusBuilder statusBuilder = new StatusBuilder(callback, reportBuilder);
        statusBuilder.plan(UNCODITIONALLY_RELAY_TO_REST_OF_METHOD_OK);
        RuntimeException ex = null;
        try {
            try {
                this.syncBreakpointsImpl(direction, statusBuilder);
            }
            catch (RuntimeException e) {
                ex = e;
                statusBuilder.done(ex);
            }
        }
        finally {
            statusBuilder.done(ex);
        }
    }

    private void syncBreakpointsImpl(Direction direction, StatusBuilder statusBuilder) {
        List<ChromiumLineBreakpoint> uiBreakpointsToCreate;
        List<ChromiumLineBreakpoint> uiBreakpointsToDelete;
        List<Object> sdkBreakpointsToCreate;
        List<Object> sdkBreakpointsToDelete;
        Collection<? extends Breakpoint> sdkBreakpoints = BreakpointSynchronizer.readSdkBreakpoints(this.javascriptVm);
        ChromiumBreakpointsFiltered uiBreakpoints = this.getUiBreakpoints();
        ArrayList<Breakpoint> lineSdkBreakpoints = new ArrayList<Breakpoint>(sdkBreakpoints.size());
        if (direction != Direction.MERGE) {
            this.breakpointHelper.getLineBreakpointMap().clear();
        }
        for (Breakpoint breakpoint : sdkBreakpoints) {
            ChromiumLineBreakpoint uiBreakpoint = this.breakpointHelper.getLineBreakpointMap().getUiBreakpoint(breakpoint);
            if (uiBreakpoint == null) {
                lineSdkBreakpoints.add(breakpoint);
                continue;
            }
            BasicUtil.removeSafe(uiBreakpoints.getLineBreakpoints(), (Object)((Object)uiBreakpoint));
            statusBuilder.getReportBuilder().increment(ReportBuilder.Property.LINKED);
        }
        SortedBreakpoints<ChromiumLineBreakpoint> sortedBreakpoints = BreakpointSynchronizer.sortBreakpoints(uiBreakpoints.getLineBreakpoints(), this.uiBreakpointHandler);
        SortedBreakpoints<Breakpoint> sortedSdkBreakpoints = BreakpointSynchronizer.sortBreakpoints(lineSdkBreakpoints, sdkBreakpointHandler);
        BreakpointMerger breakpointMerger = new BreakpointMerger(direction, this.breakpointHelper.getLineBreakpointMap());
        BreakpointSynchronizer.mergeBreakpoints(breakpointMerger, sortedBreakpoints, sortedSdkBreakpoints);
        if (direction == Direction.RESET_REMOTE) {
            sdkBreakpointsToDelete = breakpointMerger.getMissingSdk();
            sdkBreakpointsToCreate = Collections.emptyList();
        } else {
            sdkBreakpointsToCreate = breakpointMerger.getMissingSdk();
            sdkBreakpointsToDelete = Collections.emptyList();
        }
        if (direction == Direction.RESET_LOCAL) {
            uiBreakpointsToDelete = breakpointMerger.getMissingUi();
            uiBreakpointsToCreate = Collections.emptyList();
        } else {
            uiBreakpointsToCreate = breakpointMerger.getMissingUi();
            uiBreakpointsToDelete = Collections.emptyList();
        }
        this.deteleBreakpoints(sdkBreakpointsToDelete, uiBreakpointsToDelete, statusBuilder);
        this.createBreakpoints(sdkBreakpointsToCreate, uiBreakpointsToCreate, statusBuilder);
        this.breakpointHelper.registerExceptionBreakpoint(uiBreakpoints.getExceptionBreakpoints());
    }

    private void deteleBreakpoints(List<Breakpoint> sdkBreakpointsToDelete, List<ChromiumLineBreakpoint> uiBreakpointsToDelete, final StatusBuilder statusBuilder) {
        for (Breakpoint sdkBreakpoint : sdkBreakpointsToDelete) {
            final PlannedTaskHelper deleteTaskHelper = new PlannedTaskHelper(statusBuilder);
            JavascriptVm.BreakpointCallback callback = new JavascriptVm.BreakpointCallback(){

                public void failure(String errorMessage) {
                    deleteTaskHelper.setException(new Exception(errorMessage));
                }

                public void success(Breakpoint breakpoint) {
                    statusBuilder.getReportBuilder().increment(ReportBuilder.Property.DELETED_ON_REMOTE);
                }
            };
            RelayOk relayOk = sdkBreakpoint.clear(callback, (SyncCallback)deleteTaskHelper);
            deleteTaskHelper.registerSelf(relayOk);
        }
        for (ChromiumLineBreakpoint uiBreakpoint : uiBreakpointsToDelete) {
            ChromiumLineBreakpoint.getIgnoreList().add(uiBreakpoint);
            try {
                try {
                    uiBreakpoint.delete();
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                ChromiumLineBreakpoint.getIgnoreList().remove(uiBreakpoint);
            }
            statusBuilder.getReportBuilder().increment(ReportBuilder.Property.DELETED_LOCALLY);
        }
    }

    private void createBreakpoints(List<Breakpoint> sdkBreakpointsToCreate, List<ChromiumLineBreakpoint> uiBreakpointsToCreate, final StatusBuilder statusBuilder) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        for (Breakpoint sdkBreakpoint : sdkBreakpointsToCreate) {
            Object sourceElement = this.sourceDirector.getSourceElement(sdkBreakpoint);
            if (!(sourceElement instanceof IFile)) {
                statusBuilder.getReportBuilder().addProblem(ReportBuilder.Problem.UNRESOLVED_REMOTE_BREAKPOINT, (String)sdkBreakpoint.getTarget().accept(ChromiumDebugPluginUtil.BREAKPOINT_TARGET_TO_STRING));
                continue;
            }
            int script_line_offset = 0;
            IFile resource = (IFile)sourceElement;
            try {
                ChromiumLineBreakpoint uiBreakpoint = ChromiumLineBreakpoint.Helper.createLocal(sdkBreakpoint, breakpointManager, resource, script_line_offset, this.debugModelId);
                this.breakpointHelper.getLineBreakpointMap().add(sdkBreakpoint, uiBreakpoint);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            statusBuilder.getReportBuilder().increment(ReportBuilder.Property.CREATED_LOCALLY);
        }
        for (ChromiumLineBreakpoint uiBreakpoint : uiBreakpointsToCreate) {
            VmResourceRef vmResourceRef = this.uiBreakpointHandler.getVmResourceRef(uiBreakpoint);
            if (vmResourceRef == null) continue;
            final PlannedTaskHelper createTaskHelper = new PlannedTaskHelper(statusBuilder);
            BreakpointHelper.CreateCallback createCallback = new BreakpointHelper.CreateCallback(){

                @Override
                public void success() {
                    statusBuilder.getReportBuilder().increment(ReportBuilder.Property.CREATED_ON_REMOTE);
                }

                @Override
                public void failure(Exception ex) {
                    createTaskHelper.setException(ex);
                }
            };
            try {
                RelayOk relayOk = this.breakpointHelper.createBreakpointOnRemote(uiBreakpoint, vmResourceRef, createCallback, createTaskHelper);
                createTaskHelper.registerSelf(relayOk);
            }
            catch (CoreException e) {
                statusBuilder.addOnStartException((Exception)((Object)e));
            }
        }
    }

    private static <B> SortedBreakpoints<B> sortBreakpoints(Collection<? extends B> breakpoints, PropertyHandler<B> handler) {
        HashMap result = new HashMap();
        for (B breakpoint : breakpoints) {
            VmResourceRef vmResourceRef = handler.getVmResourceRef(breakpoint);
            if (vmResourceRef == null) continue;
            HashMap<Long, B> subMap = (HashMap<Long, B>)BasicUtil.getSafe(result, (Object)vmResourceRef);
            if (subMap == null) {
                subMap = new HashMap<Long, B>(3);
                result.put(vmResourceRef, subMap);
            }
            long line = handler.getLineNumber(breakpoint);
            subMap.put(line, breakpoint);
        }
        return new SortedBreakpoints(result);
    }

    private static <K, V1, V2> void mergeMaps(Map<K, V1> map1, Map<K, V2> map2, Merger<V1, V2> merger) {
        for (Map.Entry<K, V1> en : map1.entrySet()) {
            Object v2 = BasicUtil.removeSafe(map2, en.getKey());
            if (v2 == null) {
                merger.onlyFirst(en.getValue());
                continue;
            }
            merger.both(en.getValue(), v2);
        }
        for (Object v2 : map2.values()) {
            merger.onlySecond(v2);
        }
    }

    private static <B1, B2> void mergeBreakpoints(final Merger<B1, B2> perBreakpointMerger, SortedBreakpoints<B1> side1, SortedBreakpoints<B2> side2) {
        Merger perScriptMerger = new Merger<Map<Long, B1>, Map<Long, B2>>(){

            @Override
            void both(Map<Long, B1> v1, Map<Long, B2> v2) {
                BreakpointSynchronizer.mergeMaps(v1, v2, perBreakpointMerger);
            }

            @Override
            void onlyFirst(Map<Long, B1> v1) {
                BreakpointSynchronizer.mergeMaps(v1, Collections.emptyMap(), perBreakpointMerger);
            }

            @Override
            void onlySecond(Map<Long, B2> v2) {
                BreakpointSynchronizer.mergeMaps(Collections.emptyMap(), v2, perBreakpointMerger);
            }
        };
        BreakpointSynchronizer.mergeMaps(side1.data, side2.data, perScriptMerger);
    }

    private static Collection<? extends Breakpoint> readSdkBreakpoints(JavascriptVm javascriptVm) {
        CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
        class CallbackImpl
        implements JavascriptVm.ListBreakpointsCallback {
            Exception problem = null;
            Collection<? extends Breakpoint> result = null;

            CallbackImpl() {
            }

            public void failure(Exception exception) {
                this.problem = exception;
            }

            public void success(Collection<? extends Breakpoint> breakpoints) {
                this.result = breakpoints;
            }

            Collection<? extends Breakpoint> getResult() {
                if (this.problem != null) {
                    throw new RuntimeException("Failed to synchronize breakpoints", this.problem);
                }
                return this.result;
            }
        }
        CallbackImpl callback = new CallbackImpl();
        RelayOk relayOk = javascriptVm.listBreakpoints((JavascriptVm.ListBreakpointsCallback)callback, (SyncCallback)callbackSemaphore);
        boolean res = callbackSemaphore.tryAcquireDefault(relayOk);
        if (!res) {
            throw new RuntimeException("Timeout");
        }
        return callback.getResult();
    }

    private ChromiumBreakpointsFiltered getUiBreakpoints() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        final HashSet<ChromiumLineBreakpoint> lineBreakpoints = new HashSet<ChromiumLineBreakpoint>();
        final ArrayList<ChromiumExceptionBreakpoint> exceptionBreakpoints = new ArrayList<ChromiumExceptionBreakpoint>(2);
        IBreakpoint[] iBreakpointArray = breakpointManager.getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            ChromiumLineBreakpoint chromiumLineBreakpoint = ChromiumBreakpointAdapter.tryCastBreakpointOnAddition(breakpoint);
            if (chromiumLineBreakpoint != null) {
                lineBreakpoints.add(chromiumLineBreakpoint);
            } else {
                ChromiumExceptionBreakpoint chromiumExceptionBreakpoint = ChromiumExceptionBreakpoint.tryCastBreakpoint(breakpoint);
                if (chromiumExceptionBreakpoint != null) {
                    exceptionBreakpoints.add(chromiumExceptionBreakpoint);
                }
            }
            ++n2;
        }
        return new ChromiumBreakpointsFiltered(){

            @Override
            public Set<ChromiumLineBreakpoint> getLineBreakpoints() {
                return lineBreakpoints;
            }

            @Override
            public Collection<ChromiumExceptionBreakpoint> getExceptionBreakpoints() {
                return exceptionBreakpoints;
            }
        };
    }

    public static interface BreakpointHelper {
        public RelayOk createBreakpointOnRemote(ChromiumLineBreakpoint var1, VmResourceRef var2, CreateCallback var3, SyncCallback var4) throws CoreException;

        public BreakpointInTargetMap<Breakpoint, ChromiumLineBreakpoint> getLineBreakpointMap();

        public void registerExceptionBreakpoint(Collection<ChromiumExceptionBreakpoint> var1);

        public static interface CreateCallback {
            public void failure(Exception var1);

            public void success();
        }
    }

    private static class BreakpointMerger
    extends Merger<ChromiumLineBreakpoint, Breakpoint> {
        private final Direction direction;
        private final List<ChromiumLineBreakpoint> missingUi = new ArrayList<ChromiumLineBreakpoint>();
        private final List<Breakpoint> missingSdk = new ArrayList<Breakpoint>();
        private final BreakpointInTargetMap<Breakpoint, ChromiumLineBreakpoint> breakpointMap;

        BreakpointMerger(Direction direction, BreakpointInTargetMap<Breakpoint, ChromiumLineBreakpoint> breakpointMap) {
            this.direction = direction;
            this.breakpointMap = breakpointMap;
        }

        @Override
        void both(ChromiumLineBreakpoint v1, Breakpoint v2) {
            if (this.direction == Direction.MERGE) {
                this.breakpointMap.add(v2, v1);
            } else {
                this.onlyFirst(v1);
                this.onlySecond(v2);
            }
        }

        @Override
        void onlyFirst(ChromiumLineBreakpoint v1) {
            this.missingUi.add(v1);
        }

        @Override
        void onlySecond(Breakpoint v2) {
            this.missingSdk.add(v2);
        }

        List<ChromiumLineBreakpoint> getMissingUi() {
            return this.missingUi;
        }

        List<Breakpoint> getMissingSdk() {
            return this.missingSdk;
        }
    }

    public static interface Callback {
        public void onDone(IStatus var1);
    }

    private static interface ChromiumBreakpointsFiltered {
        public Set<ChromiumLineBreakpoint> getLineBreakpoints();

        public Collection<ChromiumExceptionBreakpoint> getExceptionBreakpoints();
    }

    public static enum Direction {
        RESET_REMOTE,
        RESET_LOCAL,
        MERGE;

    }

    private static abstract class Merger<V1, V2> {
        private Merger() {
        }

        abstract void onlyFirst(V1 var1);

        abstract void onlySecond(V2 var1);

        abstract void both(V1 var1, V2 var2);
    }

    private static class PlannedTaskHelper
    implements SyncCallback {
        private final StatusBuilder statusBuilder;
        private volatile Exception exception = null;
        private boolean registerCalled = false;
        private boolean doneCallDeferred = false;

        PlannedTaskHelper(StatusBuilder statusBuilder) {
            this.statusBuilder = statusBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerSelf(RelayOk relayOk) {
            boolean needCallDeferred;
            this.statusBuilder.plan(relayOk);
            PlannedTaskHelper plannedTaskHelper = this;
            synchronized (plannedTaskHelper) {
                this.registerCalled = true;
                needCallDeferred = this.doneCallDeferred;
            }
            if (needCallDeferred) {
                this.statusBuilder.done(this.exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callbackDone(RuntimeException e) {
            if (e != null) {
                this.exception = e;
            }
            PlannedTaskHelper plannedTaskHelper = this;
            synchronized (plannedTaskHelper) {
                if (!this.registerCalled) {
                    this.doneCallDeferred = true;
                    return;
                }
            }
            this.statusBuilder.done(this.exception);
        }

        void setException(Exception ex) {
            this.exception = ex;
        }
    }

    private static abstract class PropertyHandler<B> {
        private PropertyHandler() {
        }

        abstract VmResourceRef getVmResourceRef(B var1);

        abstract long getLineNumber(B var1);
    }

    public static class ProtocolNotSupportedOnRemote
    extends Exception {
        ProtocolNotSupportedOnRemote() {
        }

        ProtocolNotSupportedOnRemote(String message, Throwable cause) {
            super(message, cause);
        }

        ProtocolNotSupportedOnRemote(String message) {
            super(message);
        }

        ProtocolNotSupportedOnRemote(Throwable cause) {
            super(cause);
        }
    }

    private static class ReportBuilder {
        private final Direction direction;
        private final Map<Property, AtomicInteger> counters;
        private final Map<Problem, List<String>> problems;

        ReportBuilder(Direction direction) {
            this.direction = direction;
            this.counters = new EnumMap<Property, AtomicInteger>(Property.class);
            Property[] propertyArray = (Property[])Property.class.getEnumConstants();
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property property = propertyArray[n2];
                this.counters.put(property, new AtomicInteger(0));
                ++n2;
            }
            this.problems = new HashMap<Problem, List<String>>(1);
        }

        public void increment(Property property) {
            this.counters.get((Object)property).addAndGet(1);
        }

        public synchronized void addProblem(Problem problem, String message) {
            ArrayList<String> list = (ArrayList<String>)BasicUtil.getSafe(this.problems, (Object)((Object)problem));
            if (list == null) {
                list = new ArrayList<String>();
                this.problems.put(problem, list);
            }
            list.add(message);
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append("direction=").append((Object)this.direction);
            for (Map.Entry<Property, AtomicInteger> en : this.counters.entrySet()) {
                int number = en.getValue().get();
                if (number == 0) continue;
                builder.append(" ").append(en.getKey().getVisibleName());
                builder.append("=").append(number);
            }
            if (!this.problems.isEmpty()) {
                builder.append('\n').append(this.problems.toString());
            }
            return builder.toString();
        }

        static enum Problem {
            UNRESOLVED_REMOTE_BREAKPOINT;


            String getVisibleName() {
                return this.toString();
            }
        }

        static enum Property {
            LINKED,
            CREATED_LOCALLY,
            DELETED_LOCALLY,
            CREATED_ON_REMOTE,
            DELETED_ON_REMOTE;


            String getVisibleName() {
                return this.toString();
            }
        }
    }

    private static class SortedBreakpoints<B> {
        final Map<VmResourceRef, Map<Long, B>> data;

        SortedBreakpoints(Map<VmResourceRef, Map<Long, B>> data) {
            this.data = data;
        }
    }

    private static class StatusBuilder {
        private final Callback callback;
        private int plannedNumber = 0;
        private final List<Exception> exceptions = new ArrayList<Exception>(0);
        private boolean alreadyReported = false;
        private final ReportBuilder reportBuilder;

        StatusBuilder(Callback callback, ReportBuilder reportBuilder) {
            this.callback = callback;
            this.reportBuilder = reportBuilder;
        }

        ReportBuilder getReportBuilder() {
            return this.reportBuilder;
        }

        public synchronized void plan(RelayOk relayOk) {
            if (this.alreadyReported) {
                throw new IllegalStateException();
            }
            ++this.plannedNumber;
        }

        public void done(Exception ex) {
            boolean timeToReport = this.doneImpl(ex);
            if (timeToReport) {
                this.reportResult();
            }
        }

        public synchronized void addOnStartException(Exception ex) {
            this.exceptions.add(ex);
        }

        private synchronized boolean doneImpl(Exception ex) {
            if (ex != null) {
                this.exceptions.add(ex);
            }
            --this.plannedNumber;
            if (this.plannedNumber == 0 && !this.alreadyReported) {
                this.alreadyReported = true;
                return true;
            }
            return false;
        }

        private void reportResult() {
            Status status;
            if (this.exceptions.isEmpty()) {
                status = new Status(0, "org.eclipse.wst.jsdt.chromium.debug.core", "Breakpoint synchronization done: " + this.reportBuilder.build(), null);
            } else {
                IStatus[] subStatuses = new IStatus[this.exceptions.size()];
                int i = 0;
                while (i < subStatuses.length) {
                    subStatuses[i] = new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", this.exceptions.get(i).getMessage(), (Throwable)this.exceptions.get(i));
                    ++i;
                }
                status = new MultiStatus("org.eclipse.wst.jsdt.chromium.debug.core", 4, subStatuses, "Breakpoint synchronization errors", null);
            }
            if (this.callback != null) {
                this.callback.onDone((IStatus)status);
            }
        }
    }
}

