/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCreateRule
extends Rule {
    protected String attributeName = null;
    protected Class<?> clazz = null;
    protected String className = null;

    public ObjectCreateRule(String className) {
        this(className, (String)null);
    }

    public ObjectCreateRule(Class<?> clazz) {
        this(clazz.getName(), (String)null);
        this.clazz = clazz;
    }

    public ObjectCreateRule(String className, String attributeName) {
        this.className = className;
        this.attributeName = attributeName;
    }

    public ObjectCreateRule(String attributeName, Class<?> clazz) {
        this(clazz.getName(), attributeName);
        this.clazz = clazz;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Class<?> clazz = this.clazz;
        if (clazz == null) {
            String value;
            String realClassName = this.className;
            if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
                realClassName = value;
            }
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug((Object)String.format("[ObjectCreateRule]{%s} New '%s'", this.getDigester().getMatch(), realClassName));
            }
            clazz = this.getDigester().getClassLoader().loadClass(realClassName);
        }
        Object instance = clazz.newInstance();
        this.getDigester().push(instance);
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        Object top = this.getDigester().pop();
        if (this.getDigester().getLogger().isDebugEnabled()) {
            this.getDigester().getLogger().debug((Object)String.format("[ObjectCreateRule]{%s} Pop '%s'", this.getDigester().getMatch(), top.getClass().getName()));
        }
    }

    public String toString() {
        return String.format("ObjectCreateRule[className=%s, attributeName=%s]", this.className, this.attributeName);
    }
}

