/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.breakpointactions.AbstractBreakpointAction;
import org.eclipse.cdt.debug.core.breakpointactions.IReverseDebugEnabler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ReverseDebugAction
extends AbstractBreakpointAction {
    private REVERSE_DEBUG_ACTIONS_ENUM fOperation;

    public REVERSE_DEBUG_ACTIONS_ENUM getOperation() {
        return this.fOperation;
    }

    public void setOperation(REVERSE_DEBUG_ACTIONS_ENUM operation) {
        this.fOperation = operation;
    }

    public IStatus execute(IBreakpoint breakpoint, IAdaptable context, IProgressMonitor monitor) {
        Status errorStatus = null;
        IReverseDebugEnabler enabler = (IReverseDebugEnabler)context.getAdapter(IReverseDebugEnabler.class);
        if (enabler != null) {
            try {
                switch (this.fOperation) {
                    case TOGGLE: {
                        enabler.toggle();
                        break;
                    }
                    case ENABLE: {
                        enabler.enable();
                        break;
                    }
                    case DISABLE: {
                        enabler.disable();
                    }
                }
            }
            catch (Exception e) {
                errorStatus = new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), (Throwable)e);
            }
        } else {
            errorStatus = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, Messages.getString("ReverseDebugAction.error.0"), null);
        }
        if (errorStatus != null) {
            MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, Messages.getString("ReverseDebugAction.error.1"), null);
            ms.add((IStatus)errorStatus);
            errorStatus = ms;
        } else {
            errorStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
        return errorStatus;
    }

    public String getMemento() {
        String reverseDebugData = "";
        try {
            DocumentBuilder docBuilder = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("reverseDebugData");
            rootElement.setAttribute("operation", this.fOperation.toString());
            doc.appendChild(rootElement);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = XmlProcessorFactoryCdt.createTransformerFactoryWithErrorOnDOCTYPE();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            reverseDebugData = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reverseDebugData;
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            DocumentBuilder parser = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            String value = root.getAttribute("operation");
            if (value == null) {
                throw new Exception();
            }
            this.fOperation = REVERSE_DEBUG_ACTIONS_ENUM.valueOf(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDefaultName() {
        return Messages.getString("ReverseDebugAction.UntitledName");
    }

    public String getSummary() {
        String operation = Messages.getString("ReverseDebugAction." + this.fOperation.toString().toLowerCase());
        return String.valueOf(operation) + " " + Messages.getString("ReverseDebugAction.Summary");
    }

    public String getTypeName() {
        return Messages.getString("ReverseDebugAction.TypeName");
    }

    public String getIdentifier() {
        return "org.eclipse.cdt.debug.ui.breakpointactions.ReverseDebugAction";
    }

    public static enum REVERSE_DEBUG_ACTIONS_ENUM {
        ENABLE,
        DISABLE,
        TOGGLE;


        public static REVERSE_DEBUG_ACTIONS_ENUM getValue(int index) {
            return REVERSE_DEBUG_ACTIONS_ENUM.values()[index];
        }
    }
}

