/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.credentials;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.function.Function;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.credentials.CredentialsUI;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EGitCredentialsProvider
extends CredentialsProvider {
    private String user;
    private String password;

    public EGitCredentialsProvider() {
    }

    public EGitCredentialsProvider(String user, String password) {
        this.user = user;
        this.password = password != null && password.isEmpty() ? null : password;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.StringType || i instanceof CredentialItem.CharArrayType || i instanceof CredentialItem.YesNoType || i instanceof CredentialItem.InformationalMessage)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        if (items.length == 0) {
            return true;
        }
        CredentialItem.Username userItem = null;
        CredentialItem.Password passwordItem = null;
        boolean isSpecial = false;
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem item = credentialItemArray[n2];
            if (item instanceof CredentialItem.Username) {
                userItem = (CredentialItem.Username)item;
            } else if (item instanceof CredentialItem.Password) {
                passwordItem = (CredentialItem.Password)item;
            } else {
                isSpecial = true;
            }
            ++n2;
        }
        if (!isSpecial && userItem != null && passwordItem != null) {
            UserPasswordCredentials credentials = null;
            if (this.user != null && this.password != null) {
                credentials = new UserPasswordCredentials(this.user, this.password);
            } else {
                try {
                    credentials = Activator.getDefault().getCredentialsStore().getCredentials(uri);
                }
                catch (StorageException e) {
                    Activator.logError(MessageFormat.format(CoreText.EGitCredentialsProvider_errorReadingCredentials, uri), e);
                    this.clearCredentials(uri);
                }
            }
            if (credentials == null && (credentials = this.callCredentialsUI(ui -> ui.getCredentials(uri))) == null) {
                return false;
            }
            userItem.setValue(credentials.getUser());
            passwordItem.setValue(credentials.getPassword().toCharArray());
            return true;
        }
        return this.callCredentialsUI(ui -> ui.fillCredentials(uri, items));
    }

    public void reset(URIish uri) {
        this.clearCredentials(uri);
        this.user = null;
        this.password = null;
    }

    private void clearCredentials(URIish uri) {
        try {
            Activator.getDefault().getCredentialsStore().clearCredentials(uri);
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(CoreText.EGitCredentialsProvider_errorClearingCredentials, uri), e);
        }
    }

    private <T> T callCredentialsUI(Function<CredentialsUI, ? extends T> getter) {
        block13: {
            ServiceReference reference;
            Bundle bundle = Activator.getDefault().getBundle();
            BundleContext context = bundle.getBundleContext();
            CredentialsUI ui = (CredentialsUI)context.getService(reference = context.getServiceReference(CredentialsUI.class));
            if (ui == null) {
                Activator.logError(CoreText.EGitCredentialsProvider_noCredentialsProviderUI, null);
            } else {
                T t;
                try {
                    t = getter.apply(ui);
                }
                catch (Exception e) {
                    Activator.logError(MessageFormat.format(CoreText.EGitCredentialsProvider_credentialsProviderUIfailed, ui.getClass().getName()), e);
                    break block13;
                }
                finally {
                    try {
                        context.ungetService(reference);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                return t;
            }
        }
        return null;
    }
}

