/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.beans.binding;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.gef.common.beans.binding.MultisetExpression;
import org.eclipse.gef.common.beans.binding.MultisetExpressionHelper;
import org.eclipse.gef.common.collections.MultisetChangeListener;
import org.eclipse.gef.common.collections.ObservableMultiset;

public abstract class MultisetBinding<E>
extends MultisetExpression<E>
implements Binding<ObservableMultiset<E>> {
    private MultisetChangeListener<E> invalidatingValueObserver = new MultisetChangeListener<E>(){

        @Override
        public void onChanged(MultisetChangeListener.Change<? extends E> change) {
            MultisetBinding.this.invalidateProperties();
            MultisetBinding.this.invalidated();
            MultisetBinding.this.fireValueChangedEvent(change);
        }
    };
    private MultisetExpressionHelper<E> helper = null;
    private ObservableMultiset<E> value = null;
    private ObservableList<Observable> dependencies = null;
    private InvalidationListener invalidatingDependenciesObserver = new InvalidationListener(){

        public void invalidated(Observable observable) {
            MultisetBinding.this.invalidate();
        }
    };
    private boolean valid = false;
    private EmptyProperty emptyProperty = null;
    private SizeProperty sizeProperty = null;

    @Override
    public void addListener(ChangeListener<? super ObservableMultiset<E>> listener) {
        if (this.helper == null) {
            this.helper = new MultisetExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        if (this.helper == null) {
            this.helper = new MultisetExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    @Override
    public void addListener(MultisetChangeListener<? super E> listener) {
        if (this.helper == null) {
            this.helper = new MultisetExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    protected void bind(Observable ... dependencies) {
        if (dependencies != null && dependencies.length > 0) {
            if (this.dependencies == null) {
                this.dependencies = FXCollections.observableArrayList();
            }
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable d = observableArray[n2];
                if (d != null) {
                    this.dependencies.add((Object)d);
                    d.addListener(this.invalidatingDependenciesObserver);
                }
                ++n2;
            }
        }
    }

    protected abstract ObservableMultiset<E> computeValue();

    public void dispose() {
        if (this.dependencies != null) {
            this.unbind((Observable[])this.dependencies.toArray((Object[])new Observable[0]));
        }
        this.invalidatingDependenciesObserver = null;
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        if (this.emptyProperty == null) {
            this.emptyProperty = new EmptyProperty();
        }
        return this.emptyProperty;
    }

    protected void fireValueChangedEvent() {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent();
        }
    }

    protected void fireValueChangedEvent(MultisetChangeListener.Change<? extends E> change) {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent(change);
        }
    }

    public ObservableMultiset<E> get() {
        if (!this.valid) {
            this.value = this.computeValue();
            this.valid = true;
            if (this.value != null) {
                this.value.addListener(this.invalidatingValueObserver);
            }
        }
        return this.value;
    }

    public ObservableList<?> getDependencies() {
        if (this.dependencies == null) {
            return FXCollections.emptyObservableList();
        }
        return FXCollections.unmodifiableObservableList(this.dependencies);
    }

    public void invalidate() {
        if (this.valid) {
            if (this.value != null) {
                this.value.removeListener(this.invalidatingValueObserver);
            }
            this.valid = false;
            this.invalidateProperties();
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    private void invalidateProperties() {
        if (this.sizeProperty != null) {
            this.sizeProperty.fireValueChangedEvent();
        }
        if (this.emptyProperty != null) {
            this.emptyProperty.fireValueChangedEvent();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableMultiset<E>> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    @Override
    public void removeListener(MultisetChangeListener<? super E> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        if (this.sizeProperty == null) {
            this.sizeProperty = new SizeProperty();
        }
        return this.sizeProperty;
    }

    protected void unbind(Observable ... dependencies) {
        if (this.dependencies != null) {
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable d = observableArray[n2];
                if (d != null) {
                    this.dependencies.remove((Object)d);
                    d.removeListener(this.invalidatingDependenciesObserver);
                }
                ++n2;
            }
            if (this.dependencies.size() == 0) {
                this.dependencies = null;
            }
        }
    }

    private class EmptyProperty
    extends ReadOnlyBooleanPropertyBase {
        private EmptyProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public boolean get() {
            return MultisetBinding.this.isEmpty();
        }

        public Object getBean() {
            return MultisetBinding.this;
        }

        public String getName() {
            return "empty";
        }
    }

    private class SizeProperty
    extends ReadOnlyIntegerPropertyBase {
        private SizeProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public int get() {
            return MultisetBinding.this.size();
        }

        public Object getBean() {
            return MultisetBinding.this;
        }

        public String getName() {
            return "size";
        }
    }
}

