/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.internal.Internal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;

public class SharedCursors
extends Cursors {
    public static final Cursor CURSOR_PLUG;
    public static final Cursor CURSOR_PLUG_NOT;
    public static final Cursor CURSOR_TREE_ADD;
    public static final Cursor CURSOR_TREE_MOVE;
    private static int deviceZoom;

    static {
        deviceZoom = -1;
        CURSOR_PLUG = SharedCursors.createCursor("icons/plug-cursor.png");
        CURSOR_PLUG_NOT = SharedCursors.createCursor("icons/plugnot-cursor.png");
        CURSOR_TREE_ADD = SharedCursors.createCursor("icons/tree_add-cursor.png");
        CURSOR_TREE_MOVE = SharedCursors.createCursor("icons/tree_move-cursor.png");
    }

    private static Cursor createCursor(String sourceName) {
        ImageDescriptor src = ImageDescriptor.createFromFile(Internal.class, (String)sourceName);
        return new Cursor(null, src.getImageData(SharedCursors.getDeviceZoom()), 0, 0);
    }

    private static int getDeviceZoom() {
        if (deviceZoom == -1) {
            deviceZoom = 100;
            String deviceZoomProperty = System.getProperty("org.eclipse.swt.internal.deviceZoom");
            if (deviceZoomProperty != null) {
                try {
                    deviceZoom = Integer.parseInt(deviceZoomProperty);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return deviceZoom;
    }
}

