/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.html;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.lucene.demo.html.Entities;
import org.apache.lucene.demo.html.HTMLParserConstants;
import org.apache.lucene.demo.html.HTMLParserTokenManager;
import org.apache.lucene.demo.html.ParseException;
import org.apache.lucene.demo.html.SimpleCharStream;
import org.apache.lucene.demo.html.Tags;
import org.apache.lucene.demo.html.Token;
import org.eclipse.help.internal.search.LimitedSizeCharArrayWriter;

public class HTMLParser
implements HTMLParserConstants {
    public static int SUMMARY_LENGTH = 175;
    StringBuilder title = new StringBuilder();
    StringBuilder summary = new StringBuilder();
    Properties metaTags = new Properties();
    String currentMetaTag = null;
    String currentMetaContent = null;
    int length = 0;
    boolean titleComplete = false;
    boolean inTitle = false;
    boolean inHeading = false;
    boolean inMetaTag = false;
    boolean inIgnoredTag = true;
    boolean afterTag = false;
    boolean afterSpace = false;
    String eol = System.lineSeparator();
    private final LimitedSizeCharArrayWriter writer = new LimitedSizeCharArrayWriter(1000000L);
    private Exception exception = null;
    public HTMLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private final Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private final int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        HTMLParser.jj_la1_0();
    }

    @Deprecated
    public HTMLParser(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public String getTitle() throws IOException, InterruptedException {
        return this.title.toString().trim();
    }

    public Properties getMetaTags() throws IOException, InterruptedException {
        return this.metaTags;
    }

    public String getSummary() throws IOException, InterruptedException {
        String metaDescription = this.metaTags.getProperty("description");
        if (metaDescription != null) {
            if (metaDescription.length() > SUMMARY_LENGTH) {
                return metaDescription.substring(0, SUMMARY_LENGTH - 1);
            }
            if (metaDescription.length() > 0) {
                return metaDescription;
            }
        }
        return this.summary.toString().trim();
    }

    public Reader getReader() throws IOException {
        return new CharArrayReader(this.writer.toCharArray());
    }

    public void parse() throws IOException {
        try {
            this.HTMLDocument();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToSummary(String text) {
        if (this.summary.length() < SUMMARY_LENGTH) {
            this.summary.append(text);
            if (this.summary.length() == this.title.length() && this.summary.toString().equals(this.title.toString())) {
                this.summary.setLength(0);
            }
            if (this.summary.length() >= SUMMARY_LENGTH) {
                this.summary.setLength(SUMMARY_LENGTH - 3);
                this.summary.append("...");
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addText(String text) throws IOException {
        if (this.inIgnoredTag) {
            return;
        }
        if (this.inTitle) {
            this.title.append(text);
        } else {
            if (!this.inHeading || this.summary.length() > 0) {
                this.addToSummary(text);
            }
            if (!this.titleComplete && !this.title.toString().isEmpty()) {
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.titleComplete = true;
                    this.notifyAll();
                }
            }
        }
        this.length += text.length();
        this.writer.write(text);
        this.afterSpace = false;
    }

    void addMetaTag() throws IOException {
        this.metaTags.setProperty(this.currentMetaTag, this.currentMetaContent);
        if (this.currentMetaTag.equalsIgnoreCase("keywords") || this.currentMetaTag.equalsIgnoreCase("description")) {
            this.writer.write(32);
            this.writer.write(this.currentMetaContent);
            this.writer.write(32);
        }
        this.currentMetaTag = null;
        this.currentMetaContent = null;
    }

    void addSpace() throws IOException {
        if (!this.afterSpace) {
            if (this.inTitle) {
                this.title.append(" ");
            } else if (this.summary.length() > 0) {
                this.addToSummary(" ");
            }
            String space = this.afterTag ? this.eol : " ";
            this.length += space.length();
            this.writer.write(space);
            this.afterSpace = true;
        }
    }

    public final void HTMLDocument() throws ParseException, IOException {
        block14: {
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 10: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.Tag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 3: {
                        Token t = this.Decl();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 4: 
                    case 5: {
                        this.CommentTag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 1: {
                        this.ScriptTag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 6: {
                        Token t = this.jj_consume_token(6);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block13;
                    }
                    case 12: {
                        Token t = this.jj_consume_token(12);
                        this.addText(Entities.decode(t.image));
                        this.afterTag = false;
                        continue block13;
                    }
                    case 13: {
                        Token t = this.jj_consume_token(13);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block13;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        this.addSpace();
                        this.afterTag = false;
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    public final void Tag() throws ParseException, IOException {
        boolean inImg = false;
        Token t1 = this.jj_consume_token(2);
        String tagName = t1.image.toLowerCase();
        if (Tags.WS_ELEMS.contains(tagName)) {
            this.addSpace();
        }
        this.inTitle = tagName.equals("<title");
        this.inHeading = tagName.startsWith("<h") && tagName.length() == 3 && Character.isDigit(tagName.charAt(2));
        this.inMetaTag = tagName.equals("<meta");
        this.inIgnoredTag = tagName.equals("<style") || tagName.equals("<script");
        inImg = tagName.equals("<img");
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block9;
                }
            }
            t1 = this.jj_consume_token(16);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    this.jj_consume_token(17);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: 
                        case 20: 
                        case 21: {
                            Token t2 = this.ArgValue();
                            if (inImg && t1.image.equalsIgnoreCase("alt") && t2 != null) {
                                this.addText("[" + t2.image + "]");
                            }
                            if (this.inMetaTag && (t1.image.equalsIgnoreCase("name") || t1.image.equalsIgnoreCase("HTTP-EQUIV")) && t2 != null) {
                                this.currentMetaTag = t2.image.toLowerCase();
                                if (this.currentMetaTag != null && this.currentMetaContent != null) {
                                    this.addMetaTag();
                                }
                            }
                            if (!this.inMetaTag || !t1.image.equalsIgnoreCase("content") || t2 == null) continue block9;
                            this.currentMetaContent = t2.image;
                            if (this.currentMetaTag == null || this.currentMetaContent == null) continue block9;
                            this.addMetaTag();
                            continue block9;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    continue block9;
                }
            }
            this.jj_la1[4] = this.jj_gen;
        }
        this.jj_consume_token(18);
    }

    public final Token ArgValue() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                t = this.jj_consume_token(19);
                return t;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_1(2)) {
            this.jj_consume_token(20);
            this.jj_consume_token(24);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                t = this.jj_consume_token(23);
                this.jj_consume_token(24);
                return t;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        if (this.jj_2_2(2)) {
            this.jj_consume_token(21);
            this.jj_consume_token(26);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                t = this.jj_consume_token(25);
                this.jj_consume_token(26);
                return t;
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token Decl() throws ParseException {
        Token t;
        block9: {
            t = this.jj_consume_token(3);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        continue block8;
                    }
                    case 19: 
                    case 20: 
                    case 21: {
                        this.ArgValue();
                        continue block8;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(18);
        return t;
    }

    public final void CommentTag() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(27);
                }
                this.jj_consume_token(28);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(29);
                }
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ScriptTag() throws ParseException {
        this.jj_consume_token(1);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(14);
        }
        this.jj_consume_token(15);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{13438, 13438, 65536, 0x380000, 131072, 524288, 0x100000, 0x200000, 0x3B0000, 0x3B0000, 0x8000000, 0x20000000, 48, 16384};
    }

    public HTMLParser(InputStream stream) {
        this(stream, null);
    }

    public HTMLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public HTMLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public HTMLParser(HTMLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(HTMLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration<int[]> e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[31];
        int i = 0;
        while (i < 31) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 14) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 31) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 2) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {}
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private static final long serialVersionUID = 1L;

        private LookaheadSuccess() {
        }
    }
}

