/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.vagrant.core.Activator;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.BaseVMCommandHandler;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.Messages;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.VagrantException;
import org.eclipse.linuxtools.vagrant.core.VagrantService;

public class DestroyVMCommandHandler
extends BaseVMCommandHandler {
    @Override
    String getJobName(List<IVagrantVM> selectedVMs) {
        return Messages.DestroyVMCommandHandler_removing_title;
    }

    @Override
    String getTaskName(IVagrantVM vm) {
        return Messages.DestroyVMCommandHandler_removing_msg + vm.id();
    }

    @Override
    void executeInJob(IVagrantVM vm, IProgressMonitor monitor) {
        IVagrantConnection connection = VagrantService.getInstance();
        try {
            try {
                connection.destroyVM(vm);
                String stateLoc = Activator.getDefault().getStateLocation().toOSString();
                File vagrantDir = Paths.get(stateLoc, vm.name()).toFile();
                CommandUtils.delete(vagrantDir);
            }
            catch (InterruptedException | VagrantException e) {
                String errorMessage = Messages.DestroyVMCommandHandler_error + vm.id();
                this.openError(errorMessage, (Exception)e);
                connection.getVMs(true);
            }
        }
        finally {
            connection.getVMs(true);
        }
    }
}

