/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.quickfixes;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindError;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindStackFrame;
import org.eclipse.linuxtools.internal.valgrind.ui.Messages;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindViewPart;
import org.eclipse.linuxtools.internal.valgrind.ui.quickfixes.AbstractValgrindMarkerResolution;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WrongDeallocationResolution
extends AbstractValgrindMarkerResolution {
    private static final String DELETE = "delete";
    private static final String FREE = "free";
    private static final String NEW = "new";

    public void apply(IMarker marker, IDocument document) {
        try {
            IASTNode astNode = this.getIASTNode(marker, document);
            if (astNode != null) {
                int nodeLength = astNode.getFileLocation().getNodeLength();
                int nodeOffset = astNode.getFileLocation().getNodeOffset();
                String content = document.get(nodeOffset, nodeLength);
                if (content.contains(DELETE)) {
                    String allocFunction = this.getAllocFunction(marker, document);
                    if (allocFunction.contains(NEW)) {
                        content = document.get(nodeOffset, nodeLength).replace(DELETE, "delete[]");
                        document.replace(nodeOffset, nodeLength, content);
                    } else {
                        this.addParentheses(astNode, document);
                        if (content.contains("[")) {
                            this.removeBrackets(astNode, document);
                        }
                        content = document.get(nodeOffset, nodeLength).replace(DELETE, FREE);
                        document.replace(nodeOffset, nodeLength, content);
                    }
                } else if (content.contains(FREE)) {
                    if (this.getAllocFunction(marker, document).contains("[")) {
                        content = content.concat("[]");
                    }
                    content = content.replace(FREE, DELETE);
                    document.replace(nodeOffset, nodeLength, content);
                }
                IValgrindMessage message = this.getMessage(marker);
                this.removeMessage(message.getParent());
                ValgrindStackFrame nestedStackFrame = this.getStackBottom((IValgrindMessage)this.getNestedStack(message.getParent()));
                int nestedLine = nestedStackFrame.getLine();
                String nestedFile = nestedStackFrame.getFile();
                this.removeMarker(nestedFile, nestedLine, marker.getType());
                marker.delete();
            }
        }
        catch (CoreException | BadLocationException e) {
            IStatus status = Status.error((String)e.getMessage(), (Throwable)e);
            String title = Messages.getString("ValgrindMemcheckQuickFixes.Valgrind_error_title");
            String message = Messages.getString("ValgrindMemcheckQuickFixes.Error_applying_quickfix");
            this.showErrorMessage(title, message, status);
        }
    }

    public String getLabel() {
        return Messages.getString("ValgrindMemcheckQuickFixes.Wrong_dealloc_label");
    }

    private void showErrorMessage(String title, String message, IStatus status) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    private void addParentheses(IASTNode node, IDocument document) throws BadLocationException {
        IASTNode[] children = node.getChildren();
        if (children.length > 0 && !children[0].getRawSignature().contains("(")) {
            IASTNode childNode = children[0];
            int childNodeLength = childNode.getFileLocation().getNodeLength();
            int childNodeOffset = childNode.getFileLocation().getNodeOffset();
            String childContent = document.get(childNodeOffset, childNodeLength);
            String newChild = "(".concat(childContent).concat(")");
            document.replace(childNodeOffset - 1, childNodeLength + 1, newChild);
        }
    }

    private String getAllocFunction(IMarker marker, IDocument document) throws BadLocationException {
        IValgrindMessage[] wrongDeallocMessages;
        ValgrindStackFrame allocMessage = null;
        String file = marker.getResource().getName();
        int line = marker.getAttribute("lineNumber", 0);
        IValgrindMessage[] iValgrindMessageArray = wrongDeallocMessages = this.getMessagesByText(Messages.getString("ValgrindMemcheckQuickFixes.Wrong_dealloc_message"));
        int n = wrongDeallocMessages.length;
        int n2 = 0;
        while (n2 < n) {
            IValgrindMessage wrongDeallocMessage = iValgrindMessageArray[n2];
            ValgrindStackFrame stackBottom = this.getStackBottom(wrongDeallocMessage);
            int stackBottomLine = stackBottom.getLine();
            String stackBottomFile = stackBottom.getFile();
            if (stackBottomLine == line && file != null && stackBottomFile.endsWith(file)) {
                allocMessage = this.getStackBottom((IValgrindMessage)this.getNestedStack(wrongDeallocMessage));
            }
            ++n2;
        }
        if (allocMessage instanceof ValgrindStackFrame) {
            int allocLine = ((ValgrindStackFrame)allocMessage).getLine() - 1;
            int allocOffset = document.getLineOffset(allocLine);
            int allocLength = document.getLineLength(allocLine);
            return document.get(allocOffset, allocLength);
        }
        return null;
    }

    private void removeBrackets(IASTNode node, IDocument document) throws BadLocationException {
        int nodeLength = node.getFileLocation().getNodeLength();
        int nodeOffset = node.getFileLocation().getNodeOffset();
        String content = document.get(nodeOffset, nodeLength);
        String newContent = content.replace("[", "").replace("]", "");
        document.replace(nodeOffset, nodeLength, newContent);
    }

    private IValgrindMessage[] getMessagesByText(String text) {
        IValgrindMessage[] messages;
        ValgrindViewPart valgrindView = ValgrindUIPlugin.getDefault().getView();
        ArrayList<IValgrindMessage> foundMessages = new ArrayList<IValgrindMessage>();
        if (valgrindView != null && (messages = valgrindView.getMessages()) != null && messages.length != 0) {
            IValgrindMessage[] iValgrindMessageArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                IValgrindMessage message = iValgrindMessageArray[n2];
                if (message.getText().contains(text)) {
                    foundMessages.add(message);
                }
                ++n2;
            }
        }
        IValgrindMessage[] foundMessagesArray = new IValgrindMessage[foundMessages.size()];
        foundMessages.toArray(foundMessagesArray);
        return foundMessagesArray;
    }

    private ValgrindStackFrame getStackBottom(IValgrindMessage message) {
        IValgrindMessage[] children;
        ValgrindStackFrame stackBottom = null;
        IValgrindMessage[] iValgrindMessageArray = children = message.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IValgrindMessage child = iValgrindMessageArray[n2];
            if (child instanceof ValgrindStackFrame) {
                stackBottom = (ValgrindStackFrame)child;
            }
            ++n2;
        }
        return stackBottom;
    }

    private IValgrindMessage getMessage(IMarker marker) {
        IValgrindMessage[] wrongDeallocMessages;
        ValgrindStackFrame message = null;
        String file = marker.getResource().getName();
        int line = marker.getAttribute("lineNumber", 0);
        IValgrindMessage[] iValgrindMessageArray = wrongDeallocMessages = this.getMessagesByText(Messages.getString("ValgrindMemcheckQuickFixes.Wrong_dealloc_message"));
        int n = wrongDeallocMessages.length;
        int n2 = 0;
        while (n2 < n) {
            IValgrindMessage wrongDeallocMessage = iValgrindMessageArray[n2];
            ValgrindStackFrame stackBottom = this.getStackBottom(wrongDeallocMessage);
            int stackBottomLine = stackBottom.getLine();
            String stackBottomFile = stackBottom.getFile();
            if (stackBottomLine == line && file != null && stackBottomFile.endsWith(file)) {
                message = stackBottom;
            }
            ++n2;
        }
        return message;
    }

    private ValgrindError getNestedStack(IValgrindMessage message) {
        IValgrindMessage[] children;
        ValgrindError nestedError = null;
        IValgrindMessage[] iValgrindMessageArray = children = message.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IValgrindMessage child = iValgrindMessageArray[n2];
            if (child instanceof ValgrindError) {
                nestedError = (ValgrindError)child;
            }
            ++n2;
        }
        return nestedError;
    }

    private void removeMarker(String file, int line, String markerType) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(markerType, false, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("lineNumber", 0) == line && marker.getResource().getName().equals(file)) {
                marker.delete();
            }
            ++n2;
        }
    }

    private void removeMessage(IValgrindMessage message) {
        ValgrindViewPart valgrindView = ValgrindUIPlugin.getDefault().getView();
        valgrindView.getMessagesViewer().getTreeViewer().remove((Object)message);
    }
}

