/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.wizards;

import java.util.Arrays;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.AbstractModelDiscovererParameters;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.DiscoveryParameterLine;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.NewDiscovererMainWizardPage;
import org.eclipse.swt.widgets.TableItem;

public class ParameterCellModifier
implements ICellModifier {
    private final NewDiscovererMainWizardPage newDiscovererMainWizardPage;

    public ParameterCellModifier(NewDiscovererMainWizardPage newDiscovererMainWizardPage) {
        this.newDiscovererMainWizardPage = newDiscovererMainWizardPage;
    }

    public boolean canModify(Object element, String property) {
        DiscoveryParameterLine parameter;
        if (AbstractModelDiscovererParameters.isInheritedParameter(element)) {
            return false;
        }
        return property != "required" || !(element instanceof DiscoveryParameterLine) || (parameter = (DiscoveryParameterLine)element).getDirection() != DirectionKind.OUT;
    }

    public Object getValue(Object element, String property) {
        if (!(element instanceof DiscoveryParameterLine)) {
            throw new IllegalArgumentException("element");
        }
        DiscoveryParameterLine discoveryParameterLine = (DiscoveryParameterLine)element;
        if (property == "name") {
            return discoveryParameterLine.getName();
        }
        if (property == "description") {
            return discoveryParameterLine.getDescription();
        }
        if (property == "type") {
            return discoveryParameterLine.getType();
        }
        if (property == "direction") {
            return new Integer(Arrays.asList(DirectionKind.values()).indexOf(discoveryParameterLine.getDirection().name()));
        }
        if (property == "required") {
            return new Boolean(discoveryParameterLine.isRequired());
        }
        if (property == "multivalued") {
            return new Boolean(discoveryParameterLine.isMultivalued());
        }
        throw new IllegalArgumentException("property");
    }

    public void modify(Object element, String property, Object value) {
        TableItem tableItem = (TableItem)element;
        Object data = tableItem.getData();
        if (!(data instanceof DiscoveryParameterLine)) {
            throw new IllegalArgumentException("element");
        }
        DiscoveryParameterLine discoveryParameterLine = (DiscoveryParameterLine)data;
        if (property == "name") {
            discoveryParameterLine.setName((String)value);
        } else if (property == "description") {
            discoveryParameterLine.setDescription((String)value);
        } else if (property == "type") {
            discoveryParameterLine.setType((String)value);
        } else if (property == "direction") {
            int iValue = (Integer)value;
            if (iValue == -1) {
                discoveryParameterLine.setDirection(DirectionKind.IN);
            } else {
                discoveryParameterLine.setDirection(DirectionKind.values()[iValue]);
            }
        } else if (property == "required") {
            discoveryParameterLine.setRequired((Boolean)value);
        } else if (property == "multivalued") {
            discoveryParameterLine.setMultivalued((Boolean)value);
        } else {
            throw new IllegalArgumentException("property");
        }
        this.newDiscovererMainWizardPage.parameterDataWasModified();
    }
}

