/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.bugzilla.ui.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public final class TaskAttachmentHyperlink
implements IHyperlink {
    private final IRegion region;
    private final TaskRepository repository;
    private final String attachmentId;

    public TaskAttachmentHyperlink(IRegion region, TaskRepository repository, String attachmentId) {
        Assert.isNotNull((Object)repository);
        this.region = region;
        this.repository = repository;
        this.attachmentId = attachmentId;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return MessageFormat.format(Messages.TaskAttachmentHyperlink_Open_Attachment_X_in_Y, this.attachmentId, this.repository.getRepositoryLabel());
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        String url = this.repository.getUrl() + "/attachment.cgi?id=" + this.attachmentId;
        TasksUiUtil.openUrl((String)url);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachmentId == null ? 0 : this.attachmentId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAttachmentHyperlink other = (TaskAttachmentHyperlink)obj;
        if (this.attachmentId == null ? other.attachmentId != null : !this.attachmentId.equals(other.attachmentId)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals((Object)other.repository));
    }

    public String toString() {
        return "TaskAttachmentHyperlink [attachmentId=" + this.attachmentId + ", region=" + String.valueOf(this.region) + ", repository=" + String.valueOf(this.repository) + "]";
    }
}

