/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IOperation;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;

public class AbstractOperation
implements IOperation {
    private EnumSet<IOperationMonitor.OperationFlag> flags;
    private final List<OperationChangeListener> listeners = new CopyOnWriteArrayList<OperationChangeListener>();
    private List<IBuildElement> registeredElements;
    private final IOperationService service;

    public AbstractOperation(IOperationService service) {
        Assert.isNotNull((Object)service);
        this.service = service;
    }

    public synchronized void addFlag(IOperationMonitor.OperationFlag flag) {
        if (this.flags == null) {
            this.flags = EnumSet.of(flag);
        } else {
            this.flags.add(flag);
        }
    }

    public void addOperationChangeListener(OperationChangeListener listener) {
        this.listeners.add(listener);
    }

    protected void connect(BuildJob job, final IBuildElement element) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob() instanceof BuildJob) {
                    AbstractOperation.this.handleResult((BuildJob)event.getJob());
                }
                AbstractOperation.this.getService().getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractOperation.this.unregister(element);
                    }
                });
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
            }
        });
        job.setUser(!this.hasFlag(IOperationMonitor.OperationFlag.BACKGROUND));
    }

    protected void fireDone(final MultiStatus result) {
        OperationChangeListener[] operationChangeListenerArray = this.listeners.toArray(new OperationChangeListener[0]);
        int n = operationChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            final OperationChangeListener listener = operationChangeListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.builds.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    OperationChangeEvent event = new OperationChangeEvent(AbstractOperation.this);
                    event.setStatus((IStatus)result);
                    listener.done(event);
                }
            });
            ++n2;
        }
    }

    public IOperationService getService() {
        return this.service;
    }

    protected void handleResult(BuildJob job) {
        IStatus status = job.getStatus();
        if (status != null && !status.isOK() && status.getSeverity() != 8) {
            this.getService().handleResult(this, status);
        }
    }

    public synchronized boolean hasFlag(IOperationMonitor.OperationFlag flag) {
        if (this.flags != null) {
            return this.flags.contains(flag);
        }
        return false;
    }

    protected void register(List<? extends IBuildElement> elements) {
        if (this.registeredElements == null) {
            this.registeredElements = new ArrayList<IBuildElement>(elements.size());
        }
        for (IBuildElement iBuildElement : elements) {
            iBuildElement.getOperations().add(this);
            this.registeredElements.add(iBuildElement);
        }
    }

    public synchronized void removeFlag(IOperationMonitor.OperationFlag flag) {
        if (this.flags != null) {
            this.flags.remove(flag);
        }
    }

    public void removeOperationChangeListener(OperationChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void unregister(IBuildElement element) {
        element.getOperations().remove(this);
        if (this.registeredElements != null) {
            this.registeredElements.remove(element);
        }
    }

    protected void unregister(List<? extends IBuildElement> elements) {
        for (IBuildElement iBuildElement : elements) {
            this.unregister(iBuildElement);
        }
    }

    protected void unregisterAll() {
        if (this.registeredElements == null) {
            return;
        }
        for (IBuildElement element : this.registeredElements) {
            element.getOperations().remove(this);
        }
        this.registeredElements.clear();
    }
}

