/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.mylyn.commons.ui.ShellDragSupport;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.reviews.ui.IReviewActionListener;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHoverInput;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentInformationControl;
import org.eclipse.mylyn.internal.reviews.ui.annotations.InlineCommentEditor;
import org.eclipse.mylyn.internal.reviews.ui.annotations.Messages;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.CommentPart;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CommentPopupDialog
extends PopupDialog
implements IReviewActionListener {
    private static final int MAX_WIDTH = 500;
    private static final int MIN_HEIGHT = 70;
    private static final int ICON_BUFFER = 16;
    private Text helpText;
    private int maxWidth;
    private CommentAnnotationHoverInput annotationInput;
    private FormToolkit toolkit;
    private Composite composite;
    private ScrolledComposite scrolledComposite;
    private CommentInformationControl informationControl;
    private IReviewItem reviewItem;
    private LineRange range;
    private static CommentPopupDialog currentPopupDialog;
    private boolean editable;
    private final boolean isCommentNavigator;
    private List<IComment> commentList;
    private InlineCommentEditor commentEditor;

    public CommentPopupDialog(Shell parent, int shellStyle, IReviewItem reviewitm, LineRange range, boolean isCommentNavigator) {
        super(parent, shellStyle, false, false, false, false, false, null, null);
        this.reviewItem = reviewitm;
        this.range = range;
        this.editable = true;
        this.isCommentNavigator = isCommentNavigator;
    }

    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(CommonFormUtil.getSharedColors());
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.scrolledComposite);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.scrolledComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.getVerticalBar().setPageIncrement(4);
        this.toolkit.adapt((Composite)this.scrolledComposite);
        this.composite = this.toolkit.createComposite((Composite)this.scrolledComposite, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setContent((Control)this.composite);
        new ShellDragSupport(this.composite);
        return this.scrolledComposite;
    }

    public boolean close() {
        return this.close(false);
    }

    protected boolean close(boolean force) {
        if (!force && this.hasEdits()) {
            return false;
        }
        if (this.editable) {
            InlineCommentEditor.removeFromEditMap(this.reviewItem.getId(), this.range.getStartLine());
        }
        return super.close();
    }

    public void dispose(boolean force) {
        if (force || !this.hasEdits()) {
            currentPopupDialog = null;
            this.close(true);
            this.toolkit.dispose();
        }
    }

    public boolean hasEdits() {
        return this.commentEditor != null && this.commentEditor.hasEdits();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        if (this.composite.getChildren().length > 0) {
            this.composite.getChildren()[0].setFocus();
        }
        Point computeSize = this.composite.computeSize(-1, -1);
        if (computeSize.y > this.scrolledComposite.getSize().y) {
            this.scrolledComposite.setExpandVertical(true);
            this.composite.setSize(computeSize);
        }
    }

    public Point computeSizeHint() {
        int widthHint = 500;
        if (this.maxWidth < widthHint) {
            widthHint = this.maxWidth;
        }
        return this.getShell().computeSize(widthHint, -1, true);
    }

    public void removeFocusListener(FocusListener listener) {
        this.composite.removeFocusListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.composite.addFocusListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    protected Composite getScrolledComposite() {
        return this.scrolledComposite;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected InlineCommentEditor getCommentEditor() {
        return this.commentEditor;
    }

    protected IReviewItem getReviewItem() {
        return this.reviewItem;
    }

    protected LineRange getRange() {
        return this.range;
    }

    protected CommentAnnotationHoverInput getAnnotationInput() {
        return this.annotationInput;
    }

    protected Text getHelpText() {
        return this.helpText;
    }

    protected boolean getEditable() {
        return this.editable;
    }

    protected FormToolkit getToolkit() {
        return this.toolkit;
    }

    public Rectangle getBounds() {
        return this.getShell().getBounds();
    }

    public Rectangle getMonitorArea() {
        return this.getShell().getMonitor().getClientArea();
    }

    public Rectangle computeTrim() {
        return this.getShell().computeTrim(0, 0, 0, 0);
    }

    public void setSizeConstraints(int newMaxWidth, int newMaxHeight) {
        this.maxWidth = newMaxWidth;
    }

    public void setLocation(Point location) {
        Rectangle bounds = this.getShell().getBounds();
        Rectangle monitorBounds = this.getMonitorArea();
        bounds.x = this.constrain(location.x, monitorBounds.x, monitorBounds.x + monitorBounds.width - bounds.width);
        bounds.y = this.constrain(location.y, monitorBounds.y, monitorBounds.y + monitorBounds.height - bounds.height);
        this.getShell().setLocation(new Point(bounds.x, bounds.y));
    }

    private int constrain(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    protected void recomputeSize() {
        Rectangle bounds = this.getShell().getBounds();
        Point size = this.composite.computeSize(-1, -1);
        this.scrolledComposite.setMinSize(size);
        int height = this.constrain(size.y, 70, this.getMonitorArea().height);
        this.getShell().setSize(size.x, height);
        this.scrolledComposite.setSize(size.x, height);
        this.setLocation(new Point(bounds.x, bounds.y));
        if (this.commentEditor != null) {
            Composite editorComposite = this.commentEditor.getEditorComposite();
            if (this.scrolledComposite.getVerticalBar().isVisible() && editorComposite != null) {
                Point commentEditorSize = editorComposite.getSize();
                editorComposite.setSize(commentEditorSize.x - this.scrolledComposite.getVerticalBar().getSize().x, commentEditorSize.y);
            }
            if (editorComposite != null) {
                this.scrolledComposite.setOrigin(0, Integer.MAX_VALUE);
            }
        }
    }

    public void setHeightBasedOnMouse(int mouseY) {
        int mouseYFromBottom = this.getMonitorArea().height + this.getMonitorArea().y - mouseY;
        this.recomputeSize();
        this.setSize(500, this.constrain(mouseYFromBottom - 16, 70, this.getShell().getSize().y));
    }

    public void setSize(int width, int height) {
        Point computeSize = this.composite.computeSize(-1, -1);
        if (computeSize.x > width) {
            width = computeSize.x;
        }
        height = Math.max(height, 70);
        this.getShell().setSize(width, height);
        this.scrolledComposite.setSize(width, height);
    }

    public void setInput(Object input) {
        if (input instanceof CommentAnnotationHoverInput) {
            this.annotationInput = (CommentAnnotationHoverInput)input;
            Control[] controlArray = this.composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            currentPopupDialog = this;
            this.commentList = new ArrayList<IComment>();
            for (CommentAnnotation annotation : this.annotationInput.getAnnotations()) {
                ILocation location;
                List locations;
                if (this.reviewItem == null && annotation.getComment().getItem() instanceof IReviewItem) {
                    this.reviewItem = (IReviewItem)annotation.getComment().getItem();
                }
                if (this.range == null && !(locations = annotation.getComment().getLocations()).isEmpty() && (location = (ILocation)locations.get(0)) instanceof ILineLocation) {
                    this.range = new LineRange(((ILineLocation)location).getRangeMin(), 1);
                }
                if (this.reviewItem != null && this.reviewItem.getReview() != null && this.reviewItem.getReview().getRepository() != null && this.reviewItem.getReview().getRepository().getAccount() != null && this.reviewItem.getReview().getRepository().getAccount() != annotation.getComment().getAuthor() && annotation.getComment().isDraft()) continue;
                CommentPart part = new CommentPart(annotation.getComment(), this.annotationInput.getBehavior());
                this.commentList.add(annotation.getComment());
                part.hookCustomActionRunListener(this);
                Control control = part.createControl(this.composite, this.toolkit);
                this.toolkit.adapt(control, true, true);
            }
            this.composite.setBackground(this.toolkit.getColors().getBackground());
            this.scrolledComposite.layout(true, true);
            this.scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
            if (InlineCommentEditor.canAddCommentEditor(this.reviewItem.getId(), this.range.getStartLine())) {
                this.commentEditor = new InlineCommentEditor(this);
                this.scrolledComposite.addMouseListener((MouseListener)this.createRemoveCommentEditorListener());
                List<Section> sections = this.getScrolledCompositeSections();
                for (Section s : sections) {
                    this.recursivelyAddCommentEditorListener((Control)s, (MouseListener)this.createAddCommentEditorListener());
                }
                if (!this.commentList.isEmpty()) {
                    this.helpText = new Text(this.composite, 0);
                    this.helpText.setText(Messages.CommentPopupDialog_HelpText);
                }
            } else {
                this.editable = false;
            }
            if (this.isCommentNavigator) {
                InlineCommentEditor.addToEditMap(this.reviewItem.getId(), this.range.getStartLine());
            }
        }
    }

    protected List<Section> getScrolledCompositeSections() {
        List<Object> sections = new ArrayList<Section>();
        if (this.scrolledComposite.getChildren().length != 0 && this.scrolledComposite.getChildren()[0] instanceof Composite) {
            Composite sectionContainer = (Composite)this.scrolledComposite.getChildren()[0];
            sections = Arrays.asList(sectionContainer.getChildren()).stream().filter(Section.class::isInstance).map(Section.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return sections;
    }

    private void recursivelyAddCommentEditorListener(Control c, MouseListener listener) {
        c.addMouseListener(listener);
        if (c instanceof Composite) {
            Control[] controls;
            Control[] controlArray = controls = ((Composite)c).getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                this.recursivelyAddCommentEditorListener(control, listener);
                ++n2;
            }
        }
    }

    private Section findParentSection(Control c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Section) {
            return (Section)c;
        }
        return this.findParentSection((Control)c.getParent());
    }

    private MouseAdapter createAddCommentEditorListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Section section;
                CommentPopupDialog.this.getShell().setVisible(true);
                IComment comment = null;
                if (e.getSource() instanceof Control && (section = CommentPopupDialog.this.isCommentNavigator ? CommentPopupDialog.this.getScrolledCompositeSections().get(0) : CommentPopupDialog.this.findParentSection((Control)e.getSource())) != null && section.getData() != null && section.getData() instanceof IComment) {
                    comment = (IComment)section.getData();
                }
                if (comment != null && CommentPopupDialog.this.editable) {
                    CommentPopupDialog.this.commentEditor.createControl(CommentPopupDialog.this.composite, comment);
                }
            }
        };
    }

    private MouseAdapter createRemoveCommentEditorListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (CommentPopupDialog.this.commentEditor != null) {
                    CommentPopupDialog.this.commentEditor.removeControl();
                }
            }
        };
    }

    protected IComment getLastCommentDraft() {
        return this.commentList.stream().filter(input -> input.isDraft()).reduce((first, second) -> second).orElse(null);
    }

    protected void hideHelpText() {
        if (this.helpText != null) {
            this.helpText.dispose();
            this.helpText = null;
        }
    }

    @Override
    public void actionAboutToRun(Action action) {
        this.close(true);
    }

    @Override
    public void actionRan(Action action) {
        this.close(true);
    }

    public static CommentPopupDialog getCurrentPopupDialog() {
        return currentPopupDialog;
    }

    public void setInformationControl(CommentInformationControl crucibleInformationControl) {
        this.informationControl = crucibleInformationControl;
    }

    public CommentInformationControl getInformationControl() {
        return this.informationControl;
    }
}

