/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;
import org.eclipse.mylyn.team.ui.IContextChangeSet;
import org.eclipse.mylyn.team.ui.TeamUiUtil;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.osgi.service.prefs.Preferences;

public class ContextChangeSet
extends ActiveChangeSet
implements IAdaptable,
IContextChangeSet {
    private static final String CTX_TITLE = "title";
    public static final String SOURCE_ID = "org.eclipse.mylyn.java.context.changeset.add";
    private final ITask task;

    public ContextChangeSet(ITask task, ActiveChangeSetManager manager) {
        super(manager, task.getSummary());
        this.task = task;
        this.updateLabel();
    }

    public boolean isUserCreated() {
        return true;
    }

    @Override
    public void updateLabel() {
        super.setName(this.task.getSummary());
        super.setTitle(this.task.getSummary());
    }

    public void save(Preferences prefs) {
        super.save(prefs);
        prefs.put(CTX_TITLE, this.getTitleForPersistance());
    }

    private String getTitleForPersistance() {
        return this.getTitle() + " (" + this.task.getHandleIdentifier() + ")";
    }

    public static String getHandleFromPersistedTitle(String title) {
        int delimStart = title.lastIndexOf(40);
        int delimEnd = title.lastIndexOf(41);
        if (delimStart != -1 && delimEnd != -1) {
            return title.substring(delimStart + 1, delimEnd);
        }
        return null;
    }

    public String getComment() {
        return this.getComment(true);
    }

    @Override
    public String getComment(boolean checkTaskRepository) {
        return TeamUiUtil.getComment(checkTaskRepository, this.task, this.getChangedResources());
    }

    public void remove(IResource resource) {
        super.remove(resource);
    }

    public void remove(IResource[] newResources) {
        super.remove(newResources);
    }

    public void add(IDiff diff) {
        super.add(diff);
    }

    public void add(IDiff[] diffs) {
        super.add(diffs);
    }

    public void add(IResource[] newResources) throws CoreException {
        super.add(newResources);
    }

    @Override
    public void restoreResources(IResource[] newResources) throws CoreException {
        super.add(newResources);
        this.setComment(this.getComment(false));
    }

    public IResource[] getResources() {
        return super.getResources();
    }

    public IResource[] getChangedResources() {
        return super.getResources();
    }

    public List<IResource> getAllResourcesInChangeContext() {
        HashSet<IResource> allResources = new HashSet<IResource>();
        allResources.addAll(Arrays.asList(super.getResources()));
        if (Platform.isRunning() && ResourcesUiBridgePlugin.getDefault() != null && this.task.isActive()) {
            allResources.addAll(ResourcesUiBridgePlugin.getDefault().getInterestingResources(ContextCore.getContextManager().getActiveContext()));
        }
        return new ArrayList<IResource>(allResources);
    }

    public boolean contains(IResource local) {
        return super.contains(local);
    }

    public boolean equals(Object object) {
        if (object instanceof ContextChangeSet && this.task != null) {
            ContextChangeSet changeSet = (ContextChangeSet)object;
            return this.task.equals(changeSet.getTask());
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.task != null) {
            return this.task.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public ITask getTask() {
        return this.task;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AbstractTask.class) {
            return this.task;
        }
        if (adapter == AbstractTaskReference.class) {
            return new LinkedTaskInfo(this.getTask(), (ChangeSet)this);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Deprecated
    public static String getComment(boolean checkTaskRepository, ITask task, IResource[] resources) {
        return TeamUiUtil.getComment(checkTaskRepository, task, resources);
    }
}

