/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workbench.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.setup.workbench.CommandParameter;
import org.eclipse.oomph.setup.workbench.KeyBindingTask;
import org.eclipse.oomph.setup.workbench.WorkbenchFactory;
import org.eclipse.oomph.setup.workbench.WorkbenchPackage;
import org.eclipse.oomph.setup.workbench.provider.WorkbenchEditPlugin;

public class KeyBindingTaskItemProvider
extends SetupTaskItemProvider {
    public KeyBindingTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addSchemePropertyDescriptor(object);
            this.addPlatformPropertyDescriptor(object);
            this.addLocalePropertyDescriptor(object);
            this.addKeysPropertyDescriptor(object);
            this.addCommandPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addSchemePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_KeyBindingTask_scheme_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_KeyBindingTask_scheme_feature", "_UI_KeyBindingTask_type"), (EStructuralFeature)WorkbenchPackage.Literals.KEY_BINDING_TASK__SCHEME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPlatformPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_KeyBindingTask_platform_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_KeyBindingTask_platform_feature", "_UI_KeyBindingTask_type"), (EStructuralFeature)WorkbenchPackage.Literals.KEY_BINDING_TASK__PLATFORM, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addLocalePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_KeyBindingTask_locale_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_KeyBindingTask_locale_feature", "_UI_KeyBindingTask_type"), (EStructuralFeature)WorkbenchPackage.Literals.KEY_BINDING_TASK__LOCALE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addKeysPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_KeyBindingTask_keys_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_KeyBindingTask_keys_feature", "_UI_KeyBindingTask_type"), (EStructuralFeature)WorkbenchPackage.Literals.KEY_BINDING_TASK__KEYS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCommandPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_KeyBindingTask_command_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_KeyBindingTask_command_feature", "_UI_KeyBindingTask_type"), (EStructuralFeature)WorkbenchPackage.Literals.KEY_BINDING_TASK__COMMAND, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
        if (feature == WorkbenchPackage.Literals.KEY_BINDING_TASK__COMMAND) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            KeyBindingTask keyBindingTask = (KeyBindingTask)object;
            String command = keyBindingTask.getCommand();
            if (command != null) {
                result.add(command);
            }
            result.addAll(WorkbenchEditPlugin.getCommands().keySet());
            return result;
        }
        if (feature == WorkbenchPackage.Literals.KEY_BINDING_TASK__SCHEME) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            KeyBindingTask keyBindingTask = (KeyBindingTask)object;
            String scheme = keyBindingTask.getScheme();
            if (scheme != null) {
                result.add(scheme);
            }
            result.addAll(WorkbenchEditPlugin.getSchemes());
            return result;
        }
        return super.filterChoices(choices, feature, object);
    }

    protected boolean isChoiceArbitrary(EStructuralFeature feature, Object object) {
        if (feature == WorkbenchPackage.Literals.KEY_BINDING_TASK__COMMAND || feature == WorkbenchPackage.Literals.KEY_BINDING_TASK__SCHEME) {
            return true;
        }
        return super.isChoiceArbitrary(feature, object);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == WorkbenchPackage.Literals.KEY_BINDING_TASK__COMMAND) {
            Command command = super.createSetCommand(domain, owner, feature, value);
            Set<String> availableCommandParameters = WorkbenchEditPlugin.getCommandParameters((String)value).keySet();
            ArrayList<CommandParameter> commandParameters = new ArrayList<CommandParameter>();
            KeyBindingTask keyBindingTask = (KeyBindingTask)owner;
            block0: for (String id : availableCommandParameters) {
                CommandParameter commandParameter2;
                for (CommandParameter commandParameter2 : keyBindingTask.getCommandParameters()) {
                    if (!id.equals(commandParameter2.getID())) continue;
                    commandParameters.add(commandParameter2);
                    continue block0;
                }
                commandParameter2 = WorkbenchFactory.eINSTANCE.createCommandParameter();
                commandParameter2.setID(id);
                commandParameters.add(commandParameter2);
            }
            CompoundCommand result = new CompoundCommand();
            result.append(command);
            result.append(SetCommand.create((EditingDomain)domain, (Object)owner, (Object)WorkbenchPackage.Literals.KEY_BINDING_TASK__COMMAND_PARAMETERS, commandParameters));
            return result.unwrap();
        }
        return super.createSetCommand(domain, owner, feature, value);
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(WorkbenchPackage.Literals.KEY_BINDING_TASK__CONTEXTS);
            this.childrenFeatures.add(WorkbenchPackage.Literals.KEY_BINDING_TASK__COMMAND_PARAMETERS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/KeyBindingTask"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        KeyBindingTask keyBindingTask = (KeyBindingTask)object;
        String command = keyBindingTask.getCommand();
        String name = command == null ? null : WorkbenchEditPlugin.getCommands().get(command);
        return keyBindingTask.getKeys() + " = " + command + (name == null ? "" : " \u279d " + name);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(KeyBindingTask.class)) {
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 11: 
            case 16: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(WorkbenchPackage.Literals.KEY_BINDING_TASK__CONTEXTS, WorkbenchFactory.eINSTANCE.createKeyBindingContext()));
        newChildDescriptors.add(this.createChildParameter(WorkbenchPackage.Literals.KEY_BINDING_TASK__COMMAND_PARAMETERS, WorkbenchFactory.eINSTANCE.createCommandParameter()));
    }

    public ResourceLocator getResourceLocator() {
        return WorkbenchEditPlugin.INSTANCE;
    }
}

