/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.ui.SharedImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DSCompletionProposal
implements ICompletionProposal {
    private final IDSObject fObject;
    private final int fStartOffset;
    private final int fLength;

    public DSCompletionProposal(IDSObject object, int startOffset) {
        this(object, startOffset, 0);
    }

    public DSCompletionProposal(IDSObject object, int startOffset, int length) {
        this.fObject = object;
        this.fStartOffset = startOffset;
        this.fLength = length;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fStartOffset, this.fLength, this.fObject.toString());
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.getTextbyType(this.fObject.getType());
    }

    private String getTextbyType(int type) {
        switch (type) {
            case 2: {
                return "properties";
            }
            case 3: {
                return "property";
            }
            case 5: {
                return "provide";
            }
            case 6: {
                return "reference";
            }
            case 4: {
                return "service";
            }
            case 1: {
                return "implementation";
            }
            case 0: {
                return "component";
            }
        }
        return null;
    }

    public Image getImage() {
        if (this.fObject.getType() == 1) {
            return SharedImages.getImage("icons/obj16/class_obj.png");
        }
        if (this.fObject.getType() == 2) {
            return SharedImages.getImage("icons/obj16/properties_obj.png");
        }
        if (this.fObject.getType() == 3) {
            return SharedImages.getImage("icons/obj16/property_obj.png");
        }
        if (this.fObject.getType() == 5) {
            return SharedImages.getImage("icons/obj16/int_obj.png");
        }
        if (this.fObject.getType() == 6) {
            return SharedImages.getImage("icons/obj16/reference_obj.png");
        }
        if (this.fObject.getType() == 0) {
            return SharedImages.getImage("icons/obj16/component_obj.png");
        }
        if (this.fObject.getType() == 4) {
            return SharedImages.getImage("icons/obj16/service_obj.png");
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fStartOffset + this.fObject.toString().length(), 0);
    }
}

