/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.swt.tools.internal.Flags;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIItem;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ProgressMonitor;

public abstract class JNIGenerator
implements Flags {
    JNIClass mainClass;
    JNIClass[] classes;
    MetaData metaData;
    String delimiter = System.lineSeparator();
    PrintStream output = System.out;
    ProgressMonitor progress;

    public JNIGenerator() {
        this.metaData = new MetaData(new Properties());
    }

    public static String skipCopyrights(InputStream is) throws IOException {
        int state = 0;
        StringBuilder copyrights = new StringBuilder();
        while (state != 5) {
            int c = is.read();
            if (c == -1) {
                return null;
            }
            switch (state) {
                case 0: {
                    if (!Character.isWhitespace((char)c)) {
                        state = 1;
                    }
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (c == 42) {
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (c != 42) break;
                    state = 4;
                    break;
                }
                case 4: {
                    state = c == 47 ? 5 : 3;
                }
            }
            if (state <= 0) continue;
            copyrights.append((char)c);
        }
        return copyrights.toString();
    }

    public static boolean compare(InputStream is1, InputStream is2) throws IOException {
        int c1;
        JNIGenerator.skipCopyrights(is1);
        JNIGenerator.skipCopyrights(is2);
        do {
            int c2;
            if ((c1 = is1.read()) == (c2 = is2.read())) continue;
            return false;
        } while (c1 != -1);
        return true;
    }

    public static void output(byte[] bytes, String fileName) throws IOException {
        Object var3_5;
        Throwable throwable;
        try {
            throwable = null;
            var3_5 = null;
            try (FileInputStream is = new FileInputStream(fileName);){
                if (JNIGenerator.compare(new ByteArrayInputStream(bytes), new BufferedInputStream(is))) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        throwable = null;
        var3_5 = null;
        try (FileOutputStream out = new FileOutputStream(fileName);){
            out.write(bytes);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDelimiter(String fileName) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));){
                int c = ((InputStream)is).read();
                if (c != -1) {
                }
                return System.lineSeparator();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return System.lineSeparator();
    }

    String fixDelimiter(String str) {
        if (this.delimiter.equals("\n")) {
            return str;
        }
        int index = 0;
        int length = str.length();
        StringBuilder buffer = new StringBuilder();
        while (index != -1) {
            int start = index;
            if ((index = str.indexOf(10, start)) == -1) {
                buffer.append(str.substring(start, length));
                continue;
            }
            buffer.append(str.substring(start, index));
            buffer.append(this.delimiter);
            ++index;
        }
        return buffer.toString();
    }

    static String getFunctionName(JNIMethod method) {
        return JNIGenerator.getFunctionName(method, method.getParameterTypes());
    }

    static String getFunctionName(JNIMethod method, JNIType[] paramTypes) {
        if ((method.getModifiers() & 0x100) == 0) {
            return method.getName();
        }
        String function = JNIGenerator.toC(method.getName());
        if (!method.isNativeUnique()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(function);
            buffer.append("__");
            JNIType[] jNITypeArray = paramTypes;
            int n = paramTypes.length;
            int n2 = 0;
            while (n2 < n) {
                JNIType paramType = jNITypeArray[n2];
                buffer.append(JNIGenerator.toC(paramType.getTypeSignature()));
                ++n2;
            }
            return buffer.toString();
        }
        return function;
    }

    /*
     * Loose catch block
     */
    static String loadFile(String file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String string;
                BufferedReader br;
                FileReader fr;
                block19: {
                    block18: {
                        int read;
                        fr = new FileReader(file);
                        br = new BufferedReader(fr);
                        StringBuilder str = new StringBuilder();
                        char[] buffer = new char[1024];
                        while ((read = br.read(buffer)) != -1) {
                            str.append(buffer, 0, read);
                        }
                        fr.close();
                        string = str.toString();
                        if (br == null) break block18;
                        br.close();
                    }
                    if (fr == null) break block19;
                    fr.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fr != null) {
                                fr.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("File not found:" + file, e);
        }
    }

    static void sort(JNIMethod[] methods) {
        Arrays.sort(methods, (mth1, mth2) -> {
            int result = mth1.getName().compareTo(mth2.getName());
            return result != 0 ? result : JNIGenerator.getFunctionName(mth1).compareTo(JNIGenerator.getFunctionName(mth2));
        });
    }

    static void sort(JNIField[] fields) {
        Arrays.sort(fields, (a, b) -> a.getName().compareTo(b.getName()));
    }

    static void sort(JNIClass[] classes) {
        Arrays.sort(classes, (a, b) -> a.getName().compareTo(b.getName()));
    }

    static String[] split(String str, String separator) {
        StringTokenizer tk = new StringTokenizer(str, separator);
        ArrayList<String> result = new ArrayList<String>();
        while (tk.hasMoreTokens()) {
            result.add(tk.nextToken());
        }
        return result.toArray(new String[result.size()]);
    }

    static String toC(String str) {
        int length = str.length();
        StringBuilder buffer = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            switch (c) {
                case '_': {
                    buffer.append("_1");
                    break;
                }
                case ';': {
                    buffer.append("_2");
                    break;
                }
                case '[': {
                    buffer.append("_3");
                    break;
                }
                case '.': {
                    buffer.append("_");
                    break;
                }
                case '/': {
                    buffer.append("_");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public abstract void generate(JNIClass var1);

    public void generateCopyright() {
    }

    public void generateAutoGenNote() {
        this.outputln("/* Note: This file was auto-generated by " + JNIGenerator.class.getName() + " */");
        this.outputln("/* DO NOT EDIT - your changes will be lost. */");
        this.outputln();
    }

    public void generateIncludes() {
    }

    public void generate() {
        if (this.classes == null) {
            return;
        }
        this.generateCopyright();
        this.generateAutoGenNote();
        this.generateIncludes();
        JNIGenerator.sort(this.classes);
        JNIClass[] jNIClassArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            JNIClass clazz = jNIClassArray[n2];
            if (this.getGenerate(clazz)) {
                this.generate(clazz);
            }
            if (this.progress != null) {
                this.progress.step();
            }
            ++n2;
        }
        this.output.flush();
    }

    public void generateMetaData(String key) {
        MetaData mt = this.getMetaData();
        String data = mt.getMetaData(key, null);
        if (data == null) {
            return;
        }
        if (data.length() == 0) {
            return;
        }
        this.outputln(this.fixDelimiter(data));
    }

    public JNIClass[] getClasses() {
        return this.classes;
    }

    public boolean getCPP() {
        JNIClass[] jNIClassArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            JNIClass clazz = jNIClassArray[n2];
            if (clazz.getFlag("cpp")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getExtension() {
        return this.getCPP() ? ".cpp" : (this.getM() ? ".m" : ".c");
    }

    public String getFileName() {
        return this.getOutputName() + this.getSuffix() + this.getExtension();
    }

    protected boolean getGenerate(JNIItem item) {
        return item.getGenerate();
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public String getOutputName() {
        return this.getMainClass().getSimpleName().toLowerCase();
    }

    public boolean getM() {
        JNIClass[] jNIClassArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            JNIClass clazz = jNIClassArray[n2];
            if (clazz.getFlag("m")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public JNIClass getMainClass() {
        return this.mainClass;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progress;
    }

    public String getSuffix() {
        return "";
    }

    public void output(String str) {
        this.output.print(str);
    }

    public void outputln() {
        this.output(this.getDelimiter());
    }

    public void outputln(String str) {
        this.output(str);
        this.output(this.getDelimiter());
    }

    public void setClasses(JNIClass[] classes) {
        this.classes = classes;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setMainClass(JNIClass mainClass) {
        this.mainClass = mainClass;
    }

    public void setMetaData(MetaData data) {
        this.metaData = data;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public void setProgressMonitor(ProgressMonitor progress) {
        this.progress = progress;
    }
}

