/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.core;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.eclipse.tcf.core.StreamChannel;
import org.eclipse.tcf.protocol.IPeer;

public class ChannelLoop
extends StreamChannel {
    private final byte[] buf = new byte[4096];
    private int buf_inp;
    private int buf_out;
    private boolean waiting;
    private boolean closed;

    ChannelLoop(IPeer peer) {
        super(peer);
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized int get() throws IOException {
        try {
            while (true) {
                if (this.buf_inp != this.buf_out) {
                    int b = this.buf[this.buf_out] & 0xFF;
                    this.buf_out = (this.buf_out + 1) % this.buf.length;
                    if (this.waiting) {
                        this.waiting = false;
                        this.notifyAll();
                    }
                    return b;
                }
                if (this.closed) {
                    return -1;
                }
                this.waiting = true;
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    protected synchronized void put(int b) throws IOException {
        assert (b >= 0 && b <= 255);
        try {
            int nxt_inp;
            while (true) {
                if ((nxt_inp = (this.buf_inp + 1) % this.buf.length) != this.buf_out) break;
                if (this.closed) {
                    return;
                }
                this.waiting = true;
                this.wait();
            }
            this.buf[this.buf_inp] = (byte)b;
            this.buf_inp = nxt_inp;
            if (this.waiting) {
                this.waiting = false;
                this.notifyAll();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    protected void flush() throws IOException {
    }

    @Override
    protected synchronized void stop() throws IOException {
        this.closed = true;
        if (this.waiting) {
            this.waiting = false;
            this.notifyAll();
        }
    }
}

