/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.core.variants;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.ecf.core.TeamSynchronization;
import org.eclipse.team.internal.ecf.core.variants.RemoteResourceVariant;

class RemoteResourceVariantComparator
implements IResourceVariantComparator {
    RemoteResourceVariantComparator() {
    }

    public boolean compare(IResource local, IResourceVariant remote) {
        int remoteType;
        RemoteResourceVariant remoteVariant = (RemoteResourceVariant)remote;
        int localType = local.getType();
        if (localType != (remoteType = remoteVariant.getType())) {
            return false;
        }
        if (localType != 1 && remoteType != 1) {
            return local.getFullPath().toString().equals(remoteVariant.getPath());
        }
        if (localType == 1 && remote.isContainer()) {
            return false;
        }
        if (local instanceof IFile) {
            IFile file = (IFile)local;
            byte[] localBytes = TeamSynchronization.readFile(file);
            byte[] remoteBytes = remote.asBytes();
            return Arrays.equals(localBytes, remoteBytes);
        }
        return false;
    }

    public boolean compare(IResourceVariant base, IResourceVariant remote) {
        return true;
    }

    public boolean isThreeWay() {
        return false;
    }
}

