/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.association;

import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.DirectAssociation;
import org.eclipse.wb.internal.core.xml.model.utils.ElementTarget;

public final class PropertyAssociation
extends DirectAssociation {
    private final String m_property;

    public PropertyAssociation(String property) {
        this.m_property = property;
    }

    @Override
    public String toString() {
        return "property " + this.m_property;
    }

    @Override
    public void add(XmlObjectInfo object, ElementTarget target) throws Exception {
        target = this.preparePropertyTarget(target);
        super.add(object, target);
    }

    @Override
    public void move(XmlObjectInfo object, ElementTarget target, XmlObjectInfo oldParent, XmlObjectInfo newParent) throws Exception {
        target = this.preparePropertyTarget(target);
        super.move(object, target, oldParent, newParent);
    }

    private ElementTarget preparePropertyTarget(ElementTarget target) {
        DocumentElement targetElement = target.getElement();
        int targetIndex = target.getIndex();
        DocumentElement propertyElement = new DocumentElement();
        propertyElement.setTag(targetElement.getTag() + "." + this.m_property);
        targetElement.addChild(propertyElement, targetIndex);
        return new ElementTarget(propertyElement, 0);
    }
}

