/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.helpers;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.gef.EditPolicy;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.IEditPartDecorationListener;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;

public abstract class SelectionPolicyDecorationHelper {
    private final LayoutEditPolicy m_layoutPolicy;
    private final Map<EditPart, EditPolicy> m_policies = new WeakHashMap<EditPart, EditPolicy>();

    public SelectionPolicyDecorationHelper(LayoutEditPolicy layoutPolicy) {
        this.m_layoutPolicy = layoutPolicy;
        this.m_layoutPolicy.addEditPartListener(new IEditPartDecorationListener(){

            @Override
            public void decorate(EditPart child) {
                if (SelectionPolicyDecorationHelper.this.shouldChangePolicy(child)) {
                    SelectionPolicyDecorationHelper.this.rememberOldPolicy(child);
                    SelectionPolicyDecorationHelper.this.setNewPolicy(child);
                }
            }

            @Override
            public void undecorate(EditPart child) {
                if (SelectionPolicyDecorationHelper.this.shouldChangePolicy(child)) {
                    SelectionPolicyDecorationHelper.this.restoreOldPolicy(child);
                }
            }
        });
    }

    private void rememberOldPolicy(EditPart child) {
        EditPolicy selectionPolicy = child.getEditPolicy("Selection Feedback");
        if (selectionPolicy != null) {
            this.m_policies.put(child, selectionPolicy);
        }
    }

    private void setNewPolicy(EditPart child) {
        EditPolicy newPolicy = this.getNewPolicy(child);
        child.installEditPolicy("Selection Feedback", newPolicy);
    }

    private void restoreOldPolicy(EditPart child) {
        EditPolicy selectionPolicy = this.m_policies.get((Object)child);
        child.installEditPolicy("Selection Feedback", selectionPolicy);
    }

    protected boolean shouldChangePolicy(EditPart child) {
        return true;
    }

    protected EditPolicy getNewPolicy(EditPart child) {
        return null;
    }
}

