/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.CheckButtonEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.ComboSelectionEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.ComboTextEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.TextSingleEditor;
import org.eclipse.wb.internal.core.utils.binding.providers.BooleanPreferenceProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.IntegerPreferenceProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.StringPreferenceProvider;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class AbstractBindingComposite
extends Composite {
    protected final DataBindManager m_bindManager;
    protected final IPreferenceStore m_preferences;
    private final List<Runnable> m_updateListeners = new ArrayList<Runnable>();
    private IValidationListener m_validationListener;
    private final Map<String, IDataEditor> m_booleanEditors = new TreeMap<String, IDataEditor>();
    private final Map<String, IDataEditor> m_stringEditors = new TreeMap<String, IDataEditor>();
    private final Map<String, IDataEditor> m_integerEditors = new TreeMap<String, IDataEditor>();
    private final Listener m_controlModifyListener = new Listener(){

        public void handleEvent(Event event) {
            AbstractBindingComposite.this.notifyUpdateListeners();
        }
    };

    public AbstractBindingComposite(Composite parent, DataBindManager bindManager, IPreferenceStore preferences) {
        super(parent, 0);
        this.m_bindManager = bindManager;
        this.m_preferences = preferences;
        GridLayoutFactory.create(this);
    }

    public final void addUpdateListener(Runnable listener) {
        if (!this.m_updateListeners.contains(listener)) {
            this.m_updateListeners.add(listener);
        }
    }

    public final void removeUpdateListener(Runnable listener) {
        this.m_updateListeners.remove(listener);
    }

    private void notifyUpdateListeners() {
        String message = this.validate0();
        if (this.m_validationListener != null) {
            this.m_validationListener.update(message);
        }
        if (message != null) {
            return;
        }
        for (Runnable listener : Lists.newArrayList(this.m_updateListeners)) {
            listener.run();
        }
    }

    public void setValidationListener(IValidationListener validationListener) {
        this.m_validationListener = validationListener;
    }

    private String validate0() {
        try {
            return this.validate();
        }
        catch (Throwable e) {
            return e.getMessage();
        }
    }

    protected String validate() throws Exception {
        return null;
    }

    public void updateValidate() {
        this.notifyUpdateListeners();
    }

    public boolean performOk() {
        return true;
    }

    public void performDefaults() {
    }

    protected final CheckButtonEditor bindBoolean(Button button, String key) {
        Assert.isTrue((button.getStyle() & 0x20) != 0, "Check button expected.");
        CheckButtonEditor editor = new CheckButtonEditor(button);
        this.m_booleanEditors.put(key, editor);
        this.m_bindManager.bind(editor, new BooleanPreferenceProvider(this.m_preferences, key), true);
        button.addListener(13, this.m_controlModifyListener);
        return editor;
    }

    protected final void bindString(Text text, String key) {
        Assert.isTrue((text.getStyle() & 2) == 0, "Single line Text expected.");
        TextSingleEditor editor = new TextSingleEditor(text);
        this.m_stringEditors.put(key, editor);
        this.m_bindManager.bind(editor, new StringPreferenceProvider(this.m_preferences, key), true);
        text.addListener(24, this.m_controlModifyListener);
    }

    protected final void bindInteger(Text text, String key) {
        Assert.isTrue((text.getStyle() & 2) == 0, "Single line Text expected.");
        TextSingleEditor editor = new TextSingleEditor(text);
        this.m_integerEditors.put(key, editor);
        this.m_bindManager.bind(editor, new IntegerPreferenceProvider(this.m_preferences, key), true);
        text.addListener(24, this.m_controlModifyListener);
    }

    protected final void bindSelection(Combo combo, String key) {
        ComboSelectionEditor editor = new ComboSelectionEditor(combo);
        this.m_integerEditors.put(key, editor);
        this.m_bindManager.bind(editor, new IntegerPreferenceProvider(this.m_preferences, key), true);
        combo.addListener(13, this.m_controlModifyListener);
    }

    protected final void bindString(Combo combo, String key) {
        ComboTextEditor editor = new ComboTextEditor(combo);
        this.m_stringEditors.put(key, editor);
        this.m_bindManager.bind(editor, new StringPreferenceProvider(this.m_preferences, key), true);
        combo.addListener(24, this.m_controlModifyListener);
    }

    public final boolean getBoolean(String key) {
        IDataEditor editor = this.m_booleanEditors.get(key);
        Assert.isNotNull(editor, "Can not find boolean editor for: " + key);
        return (Boolean)editor.getValue();
    }

    public final String getString(String key) {
        IDataEditor editor = this.m_stringEditors.get(key);
        Assert.isNotNull(editor, "Can not find String editor for: " + key);
        return (String)editor.getValue();
    }

    public final int getInteger(String key) {
        IDataEditor editor = this.m_integerEditors.get(key);
        Assert.isNotNull(editor, "Can not find integer editor for: " + key);
        Object value = editor.getValue();
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }

    protected final Button checkButton(Composite parent, String text, String key) {
        return this.checkButton(parent, 1, text, key);
    }

    protected final Button checkButton(Composite parent, int horizontalSpan, String text, String key) {
        Button button = new Button(parent, 32);
        GridDataFactory.create((Control)button).spanH(horizontalSpan);
        button.setText(text);
        this.bindBoolean(button, key);
        return button;
    }

    protected final Control[] stringField(Composite parent, int horizontalSpan, String label, String key) {
        Label labelWidget = new Label(parent, 0);
        labelWidget.setText(label);
        Text text = new Text(parent, 2048);
        GridDataFactory.create((Control)text).spanH(horizontalSpan - 1).fillH();
        this.bindString(text, key);
        return new Control[]{labelWidget, text};
    }

    protected final Text integerField(Composite parent, int horizontalSpan, String label, String key) {
        new Label(parent, 0).setText(label);
        Text text = new Text(parent, 2048);
        GridDataFactory.create((Control)text).spanH(horizontalSpan - 1).fillH();
        this.bindInteger(text, key);
        return text;
    }

    public static interface IValidationListener {
        public void update(String var1);
    }
}

