/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.ColumnHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;

public abstract class DimensionHeaderAction<T extends MigDimensionInfo>
extends ObjectInfoAction {
    private final boolean m_horizontal;
    private final IEditPartViewer m_viewer;
    private final MigLayoutInfo m_layout;

    public DimensionHeaderAction(DimensionHeaderEditPart<T> editPart, String text) {
        this(editPart, text, null);
    }

    public DimensionHeaderAction(DimensionHeaderEditPart<T> editPart, String text, ImageDescriptor imageDescriptor) {
        this(editPart, text, imageDescriptor, 1);
    }

    public DimensionHeaderAction(DimensionHeaderEditPart<T> editPart, String text, ImageDescriptor imageDescriptor, int style) {
        super((ObjectInfo)editPart.getLayout(), text, style);
        this.m_horizontal = editPart instanceof ColumnHeaderEditPart;
        this.m_viewer = editPart.getViewer();
        this.m_layout = editPart.getLayout();
        this.setImageDescriptor(imageDescriptor);
    }

    public final int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
    }

    protected final void runEx() throws Exception {
        ArrayList dimensions = new ArrayList();
        List editParts = this.m_viewer.getSelectedEditParts();
        for (EditPart editPart : editParts) {
            if (!(editPart instanceof DimensionHeaderEditPart)) continue;
            DimensionHeaderEditPart headerEditPart = (DimensionHeaderEditPart)editPart;
            dimensions.add(headerEditPart.getDimension());
        }
        this.run(dimensions);
    }

    protected void run(List<T> dimensions) throws Exception {
        List<MigDimensionInfo> allDimensions = this.m_horizontal ? this.m_layout.getColumns() : this.m_layout.getRows();
        for (MigDimensionInfo dimension : dimensions) {
            int index = allDimensions.indexOf(dimension);
            this.run(dimension, index);
        }
        this.m_layout.writeDimensions();
    }

    protected void run(T dimension, int index) throws Exception {
    }
}

