/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UndoLog;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.value.Value;

public class UndoLogRecord {
    public static final short INSERT = 0;
    public static final short DELETE = 1;
    private static final int IN_MEMORY = 0;
    private static final int STORED = 1;
    private static final int IN_MEMORY_INVALID = 2;
    private Table table;
    private Row row;
    private short operation;
    private short state;
    private int filePos;

    UndoLogRecord(Table table, short s, Row row) {
        this.table = table;
        this.row = row;
        this.operation = s;
        this.state = 0;
    }

    boolean isStored() {
        return this.state == 1;
    }

    boolean canStore() {
        return this.table.getUniqueIndex() != null;
    }

    void undo(Session session) {
        Database database = session.getDatabase();
        switch (this.operation) {
            case 0: {
                if (this.state == 2) {
                    this.state = 0;
                }
                if (database.getLockMode() == 0 && this.row.isDeleted()) {
                    return;
                }
                try {
                    this.row.setDeleted(false);
                    this.table.removeRow(session, this.row);
                    this.table.fireAfterRow(session, this.row, null, true);
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getErrorCode() == 90112) break;
                    throw dbException;
                }
            }
            case 1: {
                try {
                    this.table.addRow(session, this.row);
                    this.table.fireAfterRow(session, null, this.row, true);
                    this.row.commit();
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getSQLException().getErrorCode() == 23505) break;
                    throw dbException;
                }
            }
            default: {
                DbException.throwInternalError("op=" + this.operation);
            }
        }
    }

    void append(Data data, UndoLog undoLog) {
        int n = data.length();
        data.writeInt(0);
        data.writeInt(this.operation);
        data.writeByte(this.row.isDeleted() ? (byte)1 : 0);
        data.writeInt(undoLog.getTableId(this.table));
        data.writeLong(this.row.getKey());
        data.writeInt(this.row.getSessionId());
        int n2 = this.row.getColumnCount();
        data.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            Value value = this.row.getValue(i);
            data.checkCapacity(data.getValueLen(value));
            data.writeValue(value);
        }
        data.fillAligned();
        data.setInt(n, (data.length() - n) / 16);
    }

    void save(Data data, FileStore fileStore, UndoLog undoLog) {
        data.reset();
        this.append(data, undoLog);
        this.filePos = (int)(fileStore.getFilePointer() / 16L);
        fileStore.write(data.getBytes(), 0, data.length());
        this.row = null;
        this.state = 1;
    }

    static UndoLogRecord loadFromBuffer(Data data, UndoLog undoLog) {
        UndoLogRecord undoLogRecord = new UndoLogRecord(null, 0, null);
        int n = data.length();
        int n2 = data.readInt() * 16;
        undoLogRecord.load(data, undoLog);
        data.setPos(n + n2);
        return undoLogRecord;
    }

    void load(Data data, FileStore fileStore, UndoLog undoLog) {
        int n = 16;
        undoLog.seek(this.filePos);
        data.reset();
        fileStore.readFully(data.getBytes(), 0, n);
        int n2 = data.readInt() * 16;
        data.checkCapacity(n2);
        if (n2 - n > 0) {
            fileStore.readFully(data.getBytes(), n, n2 - n);
        }
        short s = this.operation;
        this.load(data, undoLog);
        if (SysProperties.CHECK && this.operation != s) {
            DbException.throwInternalError("operation=" + this.operation + " op=" + s);
        }
    }

    private void load(Data data, UndoLog undoLog) {
        this.operation = (short)data.readInt();
        boolean bl = data.readByte() == 1;
        this.table = undoLog.getTable(data.readInt());
        long l = data.readLong();
        int n = data.readInt();
        int n2 = data.readInt();
        Value[] valueArray = new Value[n2];
        for (int i = 0; i < n2; ++i) {
            valueArray[i] = data.readValue();
        }
        this.row = new Row(valueArray, -1);
        this.row.setKey(l);
        this.row.setDeleted(bl);
        this.row.setSessionId(n);
        this.state = (short)2;
    }

    public Table getTable() {
        return this.table;
    }

    public long getFilePos() {
        return this.filePos;
    }

    void commit() {
        this.table.commit(this.operation, this.row);
    }

    public Row getRow() {
        return this.row;
    }

    void invalidatePos() {
        if (this.state == 0) {
            this.state = (short)2;
        }
    }
}

