/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssNameConverter {
    public String convertName(String className) {
        String[] bits = className.split("\\-");
        StringBuilder b = new StringBuilder();
        for (String bit : bits) {
            if (b.length() == 0) {
                b.append(bit);
                continue;
            }
            b.append(bit.substring(0, 1).toUpperCase());
            if (bit.length() <= 1) continue;
            b.append(bit.substring(1));
        }
        String converted = b.toString();
        return converted;
    }

    public Map<String, String> convertSet(Set<String> classNames) throws Failure {
        LinkedHashMap<String, String> rawToConverted = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> convertedToRaw = new LinkedHashMap<String, String>();
        for (String className : classNames) {
            String converted = this.convertName(className);
            String already = (String)convertedToRaw.get(converted);
            if (already != null) {
                throw new Failure("CSS class name collision: \"%s\" and \"%s\"", already, className);
            }
            convertedToRaw.put(converted, className);
            rawToConverted.put(className, converted);
        }
        return rawToConverted;
    }

    public static class Failure
    extends Exception {
        Failure(String message, Object ... params) {
            super(String.format(message, params));
        }
    }
}

