/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileBaseDeleteChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.swt.widgets.Shell;

public class ConnectionProfileCreateChange
extends Change {
    private String mNewProfileName;
    private String mNewProfileDescription;
    private String mNewProfileProviderID;
    private Properties mNewProfileProperties;
    private String mNewProfileParentProfile;
    private boolean mNewProfileAutoConnect;
    private boolean mNewProfileAutoConnectOnFinish;
    private IConnectionProfile mProfile;
    private Shell mShell;

    public ConnectionProfileCreateChange(String name, String description, String providerID, Properties baseProperties, String parentProfile, boolean autoConnect, Shell shell) {
        this(name, description, providerID, baseProperties, parentProfile, autoConnect, shell, false);
    }

    public ConnectionProfileCreateChange(String name, String description, String providerID, Properties baseProperties, String parentProfile, boolean autoConnect, Shell shell, boolean autoConnectOnFinish) {
        this.mNewProfileName = name;
        this.mNewProfileDescription = description;
        this.mNewProfileProviderID = providerID;
        this.mNewProfileProperties = baseProperties;
        this.mNewProfileParentProfile = parentProfile;
        this.mNewProfileAutoConnect = autoConnect;
        this.mShell = shell;
        this.mNewProfileAutoConnectOnFinish = autoConnectOnFinish;
    }

    public ConnectionProfileCreateChange(IConnectionProfile profile, Shell shell) {
        this.mProfile = profile;
        this.mShell = shell;
    }

    public String getName() {
        if (this.mNewProfileName != null) {
            return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.name"), this.mNewProfileName);
        }
        if (this.mProfile != null) {
            return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.name"), this.mProfile.getName());
        }
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.name"), "");
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IConnectionProfile repo;
        RefactoringStatus result = new RefactoringStatus();
        if (this.mProfile != null) {
            return result;
        }
        if (this.mNewProfileName == null || this.mNewProfileName.trim().length() == 0) {
            result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.error.NewProfileDoesNotHaveName"));
        }
        if (this.mNewProfileParentProfile != null && (repo = ProfileManager.getInstance().getProfileByInstanceID(this.mNewProfileParentProfile)) != null) {
            String path = String.valueOf(repo.getName()) + InternalProfileManager.PROFILE_PATH_SEPARATOR + this.mNewProfileName;
            if (ProfileManager.getInstance().getProfileByFullPath(path) != null) {
                result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.error.NewProfileAlreadyExists"));
            }
        }
        if (this.mNewProfileProviderID == null || this.mNewProfileProviderID.trim().length() == 0) {
            result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.error.NewProfileDoesNotHaveProviderID"));
        }
        if (this.mNewProfileProperties == null) {
            result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.error.NewProfileDoesNotHaveNonNullPropertiesObject"));
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        CompositeChange undo = new CompositeChange(this.getName());
        undo.markAsSynthetic();
        undo.add(this.createProfile(pm));
        return undo;
    }

    public Object getModifiedElement() {
        return this.mNewProfileName;
    }

    private Change createProfile(IProgressMonitor pm) {
        try {
            if (this.mProfile != null) {
                ProfileManager.getInstance().addProfile(this.mProfile);
            } else {
                if (this.mNewProfileDescription == null) {
                    this.mNewProfileDescription = "";
                }
                if (this.mNewProfileParentProfile == null) {
                    this.mNewProfileParentProfile = "";
                }
                ProfileManager.getInstance().createProfile(this.mNewProfileName, this.mNewProfileDescription, this.mNewProfileProviderID, this.mNewProfileProperties, this.mNewProfileParentProfile, this.mNewProfileAutoConnect);
            }
        }
        catch (ConnectionProfileException e) {
            ExceptionHandler.showException(this.mShell, ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.create.failure"), e.getLocalizedMessage(), e);
            return new NullChange();
        }
        IConnectionProfile newProfile = null;
        newProfile = this.mNewProfileName != null ? ProfileManager.getInstance().getProfileByName(this.mNewProfileName) : ProfileManager.getInstance().getProfileByName(this.mProfile.getName());
        if (newProfile != null && this.mNewProfileAutoConnectOnFinish) {
            newProfile.connect();
        }
        return new ConnectionProfileBaseDeleteChange(newProfile, new DeleteArguments());
    }
}

