/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.cdo;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.cdo.CDOSessionManager;
import org.eclipse.emf.parsley.cdo.util.CDOURIData;
import org.eclipse.emf.parsley.resource.LoadResourceResponse;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.emf.spi.cdo.CDOMergingConflictResolver;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public class CDOResourceLoader
extends ResourceLoader {
    @Inject
    private CDOSessionManager sessionManager;
    private static final Logger LOGGER = Logger.getLogger(CDOResourceLoader.class);

    public Resource getResource(ResourceSet resourceSet, URI resourceURI) {
        CDOTransaction t = this.openTransaction(resourceURI);
        t.options().addConflictResolver((CDOConflictResolver)new CDOMergingConflictResolver());
        t.options().addChangeSubscriptionPolicy(CDOAdapterPolicy.ALL);
        if (!t.hasResource(CDOURIData.parse(resourceURI).getResource())) {
            return null;
        }
        CDOResource resource = t.getResource(CDOURIData.parse(resourceURI).getResource(), true);
        resourceSet.getResources().add((Object)resource);
        return resource;
    }

    public LoadResourceResponse getResource(EditingDomain editingDomain, URI resourceURI) {
        Resource resource = null;
        Exception exception = null;
        try {
            resource = this.getResource(editingDomain.getResourceSet(), resourceURI);
            if (resource == null) {
                resource = this.createResource(editingDomain.getResourceSet(), resourceURI);
                this.getResourceManager().initialize(resource);
                ((CDOTransaction)((CDOResource)resource).cdoView()).commit();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("getResource: " + resourceURI), (Throwable)e);
            exception = e;
        }
        return new LoadResourceResponse(resource, exception);
    }

    public Resource createResource(ResourceSet resourceSet, URI resourceURI) {
        CDOTransaction t = this.openTransaction(resourceURI);
        CDOResource resource = t.getOrCreateResource(CDOURIData.parse(resourceURI).getResource());
        resourceSet.getResources().add((Object)resource);
        return resource;
    }

    private CDOTransaction openTransaction(URI resourceURI) {
        CDONet4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        CDOURIData data = CDOURIData.parse(resourceURI);
        String server = data.getServer();
        String repository = data.getRepository();
        CDOSession cdoSession = this.sessionManager.getSession(server, repository);
        CDOTransaction transaction = cdoSession.openTransaction();
        transaction.options().addChangeSubscriptionPolicy(CDOAdapterPolicy.ALL);
        return transaction;
    }
}

