/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ContainerLinkDialog
extends Dialog {
    private final IDockerConnection connection;
    private final ContainerLinkDialogModel model;
    private final List<String> containerNames;
    private final DataBindingContext dbc = new DataBindingContext();

    public ContainerLinkDialog(Shell shell, IDockerConnection connection) {
        super(shell);
        this.connection = connection;
        this.model = new ContainerLinkDialogModel();
        this.containerNames = WizardUtils.getContainerNames(connection);
    }

    public ContainerLinkDialog(Shell shell, IDockerConnection connection, ImageRunSelectionModel.ContainerLinkModel selectedContainerLink) {
        super(shell);
        this.connection = connection;
        this.model = new ContainerLinkDialogModel(selectedContainerLink);
        this.containerNames = WizardUtils.getContainerNames(connection);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText(WizardMessages.getString("ContainerLinkDialog.title"));
    }

    protected Point getInitialSize() {
        return new Point(400, super.getInitialSize().y);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            button.setEnabled(false);
        }
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        int COLUMNS = 2;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Label explanationLabel = new Label(container, 0);
        explanationLabel.setText(WizardMessages.getString("ContainerLinkDialog.explanationLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)explanationLabel);
        Label containerLabel = new Label(container, 0);
        containerLabel.setText(WizardMessages.getString("ContainerLinkDialog.containerLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)containerLabel);
        Combo containerSelectionCombo = new Combo(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)containerSelectionCombo);
        ComboViewer containerSelectionComboViewer = new ComboViewer(containerSelectionCombo);
        containerSelectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        containerSelectionComboViewer.setInput(this.model.getContainerNames());
        new ContentProposalAdapter((Control)containerSelectionCombo, (IControlContentAdapter)new ComboContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Combo combo = (Combo)control;
                Point selection = combo.getSelection();
                combo.setText(text);
                selection.y = selection.x = text.length();
                combo.setSelection(selection);
            }
        }, this.getContainerNameContentProposalProvider(containerSelectionCombo), null, null);
        Label aliasLabel = new Label(container, 0);
        aliasLabel.setText(WizardMessages.getString("ContainerLinkDialog.aliasLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)aliasLabel);
        Text containerAliasText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)containerAliasText);
        Label errorMessageLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)errorMessageLabel);
        ISWTObservableValue containerNameObservable = WidgetProperties.widgetSelection().observe((Widget)containerSelectionComboViewer.getCombo());
        this.dbc.bindValue((IObservableValue)containerNameObservable, BeanProperties.value(ContainerLinkDialogModel.class, (String)"containerName").observe((Object)this.model));
        ISWTObservableValue containerAliasObservable = WidgetProperties.text((int)24).observe((Widget)containerAliasText);
        this.dbc.bindValue((IObservableValue)containerAliasObservable, BeanProperties.value(ContainerLinkDialogModel.class, (String)"containerAlias").observe((Object)this.model));
        containerNameObservable.addValueChangeListener(this.onContainerLinkSettingsChanged());
        containerAliasObservable.addValueChangeListener(this.onContainerLinkSettingsChanged());
        return container;
    }

    private IValueChangeListener onContainerLinkSettingsChanged() {
        return event -> this.validateInput();
    }

    public String getContainerName() {
        return this.model.getContainerName();
    }

    public String getContainerAlias() {
        return this.model.getContainerAlias();
    }

    private IContentProposalProvider getContainerNameContentProposalProvider(Combo containerSelectionCombo) {
        return (contents, position) -> {
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            for (String containerName : containerSelectionCombo.getItems()) {
                if (!containerName.contains(contents)) continue;
                proposals.add(new ContentProposal(containerName, containerName, containerName, position));
            }
            return proposals.toArray(new IContentProposal[0]);
        };
    }

    private void validateInput() {
        String selectedContainerName = this.model.getContainerName();
        Object[] containerNames = this.model.getContainerNames().toArray();
        String containerAlias = this.model.getContainerAlias();
        if (selectedContainerName == null || selectedContainerName.isEmpty()) {
            this.setOkButtonEnabled(false);
        } else if (Arrays.binarySearch(containerNames, 0, containerNames.length, selectedContainerName) < 0) {
            this.setOkButtonEnabled(false);
        } else {
            if (containerAlias == null || containerAlias.isEmpty()) {
                this.setOkButtonEnabled(false);
                return;
            }
            this.setOkButtonEnabled(true);
        }
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    class ContainerLinkDialogModel
    extends BaseDatabindingModel {
        public static final String CONTAINER_NAME = "containerName";
        public static final String CONTAINER_ALIAS = "containerAlias";
        private String containerName;
        private String containerAlias;

        public ContainerLinkDialogModel() {
        }

        public ContainerLinkDialogModel(ImageRunSelectionModel.ContainerLinkModel selectedContainerLink) {
            this();
            this.containerName = selectedContainerLink.getContainerName();
            this.containerAlias = selectedContainerLink.getContainerAlias();
        }

        public IDockerConnection getConnection() {
            return ContainerLinkDialog.this.connection;
        }

        private List<String> getContainerNames() {
            return ContainerLinkDialog.this.containerNames;
        }

        public List<IDockerContainer> getContainers() {
            return this.getConnection().getContainers();
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
            this.firePropertyChange(CONTAINER_NAME, this.containerName, this.containerName);
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public void setContainerAlias(String containerAlias) {
            this.containerAlias = containerAlias;
            this.firePropertyChange(CONTAINER_ALIAS, this.containerAlias, this.containerAlias);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.containerAlias == null ? 0 : this.containerAlias.hashCode());
            result = 31 * result + (this.containerName == null ? 0 : this.containerName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerLinkDialogModel other = (ContainerLinkDialogModel)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.containerAlias == null ? other.containerAlias != null : !this.containerAlias.equals(other.containerAlias)) {
                return false;
            }
            return !(this.containerName == null ? other.containerName != null : !this.containerName.equals(other.containerName));
        }

        private ContainerLinkDialog getOuterType() {
            return ContainerLinkDialog.this;
        }
    }
}

